/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_ENABLED = "createButton.enabled";
    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JButton createButton;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(groupUsers.getCombo(), EntityRenderer.getInstance());
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    /**
     * Fill groups and users ListSelectorUI.
     */
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        if (bean == null) {
            return;
        }
    
        Set<String> users = bean.getUser();
    
        java.util.List<User> toUserList = new java.util.ArrayList<User>();
        if (users != null){
            for (String user : users){
                User userToAdd = VradiService.getWikittyProxy().restore(User.class, user);
                toUserList.add(userToAdd);
            }
        }
    
        java.util.List<User> toUserCombo = new java.util.ArrayList<User>(getHandler().getAllUsers());
    
        toUserCombo.removeAll(toUserList);
    
        // Sort
        Collections.sort(toUserList, VradiComparators.USER_COMPARATOR);
        Collections.sort(toUserCombo, VradiComparators.USER_COMPARATOR);
    
        groupUsers.init(toUserCombo, toUserList);
    
        requestListUI.setBean(getBean());
        requestListUI.init();
    }
    
    @Override
    public void save() {
        setModified(false);
    
        //Use new list to avoid empty queries after clearing
        Group bean = requestListUI.getBean();
        java.util.List<String> queries = null;
        if (bean.getQueries()!=null){
            queries = new java.util.ArrayList<String>(requestListUI.getBean().getQueries());
        }
    
        //Store queries
        bean.clearQueries();
        if (queries!=null){
            for (String query : queries) {
                bean.addQueries(query);
            }
        }
    
        //Store users
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            log.debug("Store user : " + user.getName());
            bean.addUser(user.getWikittyId());
        }
    
        //Set modified to false just before saving to avoid multiple confirmation
        setModified(false);
        Group group = getHandler().saveGroup(this, getHelper(), bean);
    
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setBean(null);
        setBean(group);
    
        groupUsers.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        groupName.setText("");
        groupUsers.init(null, null);
    }
    
    protected String updateTitle(String name) {
        return _("vradi.adminGroup.title", getStringValue(name));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this);setModified(true);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        getBean().setName(groupName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("name", groupName);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 2.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(requestListUI, new GridBagConstraints(0, 2, 2, 1, 1.0, 3.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminGroup.createGroup"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        
        requestListUI.setName("requestListUI");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group >(com.jurismarches.vradi.entities.Group.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeUser"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminGroupForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        createRequestListUI();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_ENABLED, true ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setEnabled(!isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUP_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}