/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.InfogeneImpl;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.models.FieldSelectModel;
import com.jurismarches.vradi.ui.admin.popups.TemplateFieldBindingUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidatorMessageListRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminFormTypeUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<WikittyExtension> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TEMPLATE_CHOICE_MODEL = "templateChoice.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1aTW/byBmmFX87Thw7trNxNnGcYOEUazpOC2wXCbaxtVJsr/IBS95N64M7IkfSJBSHGQ5teo0U/Qn9Ce29lwK99VT00HMPvRT9C0XRQ69F3xl+06RESxsgjM1532ee55mZd4Zkfv8vZcxmyv13yHVV5picdLG6v/327evmO6zxr7GtMWJxyhTvz0hJKR0pM3p43+bKg6OaSN/00zfLtGtRE5ux7Kc1ZdrmZwa2OxhzrnyazNBse7MeNj91LYcFqCGpLNTf/uffpd/ov/5dSVFcC9jdAimr/bIiJaM1pUR0rsxDTydo00BmG2gwYraB76y4VzaQbb9CXfxB+ZUyUVPGLcQAjCtrxSVLDJnvWlyZe7itd4lZpiaH8MO9x1z5QqNd9Z3DiN1FTOtgWz1hSCeqQ1QkYlXNC1ZlZpWybuPMwod7liVhx7ky2sTIhIGgrK2aDuHUVE/Je8L5mfqd92/FBQSbUDNKmtYQ02vojDqg527CNfsUPFDLYfuTKGuCU2o0EePKrYyUBmoaOAoe44QbGAwWXrp+zH4NNbEhIua5MiUjarjFI1oMI46FTK4sJBJ3gCk1ZWZMOtXP0j28QSY2IhozLYINvUZs8Fvcuikud8LmyYcepcfi92VxuRdvk2Cy7W6ybcZnKsDFrRVxeRA2z3aITtme2aJtbOJsi3dFSCQrlvxwv64xahiid5gjywl9UVOS0ZQYUsk3pPujaOT8aSTBLjD5doe6InAjkk586iHWxgVbtjJsCezcCu38Sdh2jeOuZYBp5Q4lGpiymNAFy6hJfSJR0oyJTxt+Xuhz1Dyn01PToEjvEbMY9LtDTB26iizPC6y4CH7AuYFXYVXzl1QnMLf0bEt3fSUw05iykgiAgqdGBS+qSCNHyhhz4DYsr6OLNfIAmrzqeCtVHQWgbP3f0sLf//TPP1aDkvgl9L2YGRqr6FCqLEYtzDgRXV/36qHDibH5EllPj5QpGxuwHchyfyeDWN1vBnLQ3w2Rrop0dRfZHYAYm/jHn/+y9Mu/XVFKVWVaDFYVifg9KAAdBi5QQ3etnz2XjK6eTsJ1Dv5egSndgmguygqUkxYybPh3nFrogxO7MdukTMfsDSIww/Xgvgs+3cnwKSTbnPrrfxfqf3geeDUC3D/JDY/8GvuFMk5Mg5hYbiD+3pC5YcxYNnZ0Gu0BWbuCAvvC5H4DCusOYn7Z+kZeX2dZMicWMjEd6thB+R7lTPgxD3tQgzpap+JayNQ91/y2GZ2cEDCpTr6H30pbT1xH9PCd1C1++rmgMb1ftwzCxeLuQ2QUqnOHMvI9kEHGtkHaZldWlwfn8TVdF1fY7WwOO5StliuvGpWDj2JcIW/D9sg8gQq3FIE1sMvfUJtw2K9gNp579STKnZG5p5i0O1zuADB5ssSMe4lWsBENpud+Lz21SrVxKTWzgRo/8/JaUlvmpfWs9dJzsPdi93KCrgWCgtTLK5qWig5EQk9JpehEseAdkeRv6ik24AgldhMdt5Bj8LJBbfwa6hnyOC7o9NikvANSj6l5rInmi5xAdRcqSJXB8rX6zP4RoHLckeznztfgpCYyVTDYWfuYhTwqmvqBXhGLFcyFOe/JE0lqiwjBk10Td6lJNK6MVKPOF5Ody+BsBpOivUqMvtLGQha3PRZQqcFFcQptkbYTeBonVIYx9KL2RG1Sxr1YmAvitNggVkPi3c3Hg5G0IlUPMlQl47M1LgYay/HY4oKXUrarBtVQ2v202CnOkGmLM0Naby5coPNOlk4vKFvgXCCwBs8qDmoXGcwJbIqNALbFrfP7SNOwxWuyi/U25p5R649U+Nm/++jz1bUWO64erD36mHbGHzqPotpiKSsmyNZPzQ1xO2nE7ezs5KDfyzcDYrP9mE/7UT3o58j4YI5g8/jFTl9HnPfJuXKYaZCIKmCQ8764Qc77ggYdflPAIF/icoJVyzEMeLjFWOg4ITaRp4v58/vEPjR1rFFYbVhfFxbFLXiTsmA6jpN0YSWnv6QNq1k2RMF9fKiGgcV9+CTBy4QnU5ThxI3z3ka8ShkxZ2B0gjfy7fg0t9ukIZ9lzosUeLYtNwNbXsXQi9fLGwmG2CU8KfltSvKoF5KUuXgBJCnvdpY8EZYt6WogqQIhA+648t1DXMjLHjsuBPfacaG5OIv5GAvPEDtJZDsispwi4sVnU5kREdseYHE2c3E24t1TLpfix5ApyUSAFedxI8ZDM4g8xaZ25EFMuR5SKUvQwYxpM+pYST4vBuNzLeTzQmAWp7OQmrvi9WDuifEyjGZDRpebxjdjhNyuUecMo+6F0jAIo/mQ0dsAd7B5BM873Ektrvqw86guQQfziXewjRyW5tQY1qdGgDvY9MbQn5GkVBl43VcEWHEeS2keWVVowMUfLbZLklqOkSJdizJeccU1yWpvEI/k6X4vhlmc1d0cVrBRXiRXGcyyaTmEPxQx75dc1y5NzPOtOLF7ecQYJnCKc5PMDobYdw88wMHOIl6fcSo4f2qJuz3OIrvio8iAh7tMHsnDnRfS63AnInof7mREvoyrgYxhpNiEp7ZHOy3FC+klRUQUkCLC+kipQ0hxKfMJFqgpX/+mTmUJLWN+TOariThMUs1KlhoZ1+OoIORsi5gCz1ZTLao5dvLFfoL4pHxN10DNNPfk49gHh/DdcF5dFx/G6AlmleARv/c3gkjw3Uiw+KToCQ4o5CyqoLmf3BJXxg3/Vf3KuYlPV3eo6727X/e/p36++lg8MAZsFiI2fkA2heBzbIH3ldFbj2vPdMTRatP7FvbVBdwRcZ0uALnq2Pi1aZx96z0DR1/BSdf72gyZpcVs/LkC+MGcf+Z9bVlFnDPSdDjO4Xy7L6YgdE9cVrMR1gqw8oeyh7aHRbQRrac/nw2tpT8CTOEO0bFYVj2YrBfBsTv09AfAGeeItfGwKLMeij8thwITyY96IKhDI/x46IH+osjXii7V5X8LyKPxZZFRZhhOMgyzoXD6yXk2NMJXQyM8Hxphp4CfWR/oekB+DZD/B2mOYBKxJQAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminFormTypeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.nuiton.wikitty.WikittyExtension bean;
    protected jaxx.runtime.swing.CardLayout2 cardLayout;
    protected javax.swing.JPanel cardPanel;
    protected jaxx.runtime.swing.VBox content;
    protected javax.swing.JButton createField;
    protected javax.swing.JButton createForm;
    protected javax.swing.JButton downloadTemplate;
    protected jaxx.runtime.swing.Table fieldListUI;
    protected jaxx.runtime.swing.HidorButton hidorInfogene;
    protected javax.swing.JPanel infogene;
    protected jaxx.runtime.swing.HBox lastModified;
    protected javax.swing.JButton newTemplate;
    protected javax.swing.JButton templateBindingButton;
    protected javax.swing.JComboBox templateChoice;
    protected javax.swing.JButton templateExampleButton;
    protected javax.swing.JLabel title;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminFormTypeUI $AdminContentUI0 = this;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void postLoadBean() {
    
        title.setText(_("vradi.adminForm.title", getStringValue(bean == null ? "" : bean.getName())));
        if (bean == null) {
            return;
        }
    
        // Fill other fields that infogene
        int i = 0;
        Collection<String> fieldNames = bean.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldType fieldType = bean.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    VradiHelper.getFieldTypeEnum(fieldType), i);
            create(fieldSelectModel);
            i = i + 1;
        }
        fillInfogenePanel();
        setModified(false);
        validate();
    }
    
    @Override
    public void save() {
        getHandler().saveFormType(this, getHelper());
        setModified(false);
    }
    
    @Override
    protected void clearUI() {
        content.removeAll();
    }
    
    protected void create() {
        create(new FieldSelectModel(content.getComponentCount()));
    }
    
    protected void create(FieldSelectModel fieldSelectModel){
        FieldSelectUI result = new FieldSelectUI(this);
    
        result.updateBean(fieldSelectModel);
        result.addPropertyChangeListener(FieldSelectUI.PROPERTY_MODIFIED, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                FieldSelectUI field = (FieldSelectUI) evt.getSource();
                if (log.isDebugEnabled()) {
                    log.debug("field " + field + " modified value =  " + evt.getNewValue());
                }
                setModified(true);
                if(evt.getNewValue() == null) {
    
                    if(field != null) {
                        field.setVisible(false);
                        content.remove(field);
                    }
                    if(field.getBean().isUpOrDown() != null) {
                        if(field.getBean().isUpOrDown() && field.getBean().getPosition() == 0) {
                            content.add(field, 0);
                        } else if(!field.getBean().isUpOrDown() && field.getBean().getPosition() == content.getComponentCount()) {
                            content.add(field);
                        } else {
                            int fieldToMovePosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition();
                            int fieldToAddPosition = field.getBean().isUpOrDown() ?
                                    field.getBean().getPosition() - 1 : field.getBean().getPosition() + 1;
                            FieldSelectUI fieldToMove = (FieldSelectUI) content.getComponent(fieldToMovePosition);
                            if (log.isDebugEnabled()) {
                                log.debug(fieldToMove.getBean().getNameValue() + " : " + fieldToMove.getBean().getPosition());
                            }
    
                            content.add(field, fieldToAddPosition);
                            for(int i = 0 ; i < content.getComponentCount() ; i++) {
                                FieldSelectUI fieldSelectUI = (FieldSelectUI) content.getComponent(i);
                                fieldSelectUI.getBean().setPosition(i);
                                if (log.isDebugEnabled()) {
                                    log.debug(fieldSelectUI.getBean().getNameValue() + " : " + fieldSelectUI.getBean().getPosition());
                                }
                            }
                        }
                        field.getBean().setUpOrDown(null);
                        field.setVisible(true);
                    }
                    content.validate();
                }
            }
        });
        result.setModified(false);
    
        content.add(result);
        validate();
    }
    
    private void fillInfogenePanel() {
        infogene.removeAll();
        WikittyExtension extension = InfogeneImpl.extensionInfogene;
        int i = 0;
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FIELD_INFOGENE_DEPARTMENT);
        fillInfogenePanel(fieldNames, extension, i);
    
        extension = FormImpl.extensionForm;
        fieldNames.clear();
        fieldNames.add(Form.FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FIELD_FORM_DATEPEREMPTION);
        fillInfogenePanel(fieldNames, extension, i);
    }
    
    private void fillInfogenePanel(java.util.List<String> fieldNames,
                                   WikittyExtension extension, int i) {
        for (String fieldName : fieldNames) {
            FieldType fieldType = extension.getFieldType(fieldName);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
    
            FieldSelectModel fieldSelectModel = new FieldSelectModel(fieldName, fieldDesc,
                    FieldTypeEnum.valueOf(fieldType), i);
    
            FieldDisplayUI fieldDisplayUI = new FieldDisplayUI(this);
            fieldDisplayUI.updateBean(fieldSelectModel);
    
            infogene.add(fieldDisplayUI);
            i = i + 1;
        }
    
    }
    
    private void onHidorInfogene() {
        if (hidorInfogene.isSelected()) {
            cardLayout.show(cardPanel, "infogene");
        } else {
            cardLayout.show(cardPanel, "content");
        }
    }
    
    private void openTemplateFieldBindingUI() {
        TemplateFieldBindingUI templateFieldBindingUI =
                new TemplateFieldBindingUI(this);
        getHandler().updateTemplateFieldTableModel(templateFieldBindingUI,
                getBean(), (String) templateChoice.getSelectedItem());
        templateFieldBindingUI.setVisible(true);
    }
    
    protected void addNewTemplate() {
        if (getHandler().uploadNewTemplate(this)) {
            openTemplateFieldBindingUI();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminFormTypeUI() {
        super();
        $initialize();
    }

    public AdminFormTypeUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createField(java.awt.event.ActionEvent event) {
        create();
    }

    public void doActionPerformed__on__createForm(java.awt.event.ActionEvent event) {
        getHandler().createFormType(this, getHelper()); setModified(true);
    }

    public void doActionPerformed__on__downloadTemplate(java.awt.event.ActionEvent event) {
        getHandler().downloadTemplate(this);
    }

    public void doActionPerformed__on__hidorInfogene(java.awt.event.ActionEvent event) {
        onHidorInfogene();
    }

    public void doActionPerformed__on__newTemplate(java.awt.event.ActionEvent event) {
        addNewTemplate();
    }

    public void doActionPerformed__on__templateBindingButton(java.awt.event.ActionEvent event) {
        openTemplateFieldBindingUI();
    }

    public void doActionPerformed__on__templateChoice(java.awt.event.ActionEvent event) {
        setModified(true);
    }

    public void doActionPerformed__on__templateExampleButton(java.awt.event.ActionEvent event) {
        getHandler().showTemplateExample(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.nuiton.wikitty.WikittyExtension getBean() {
        return bean;
    }

    public jaxx.runtime.swing.CardLayout2 getCardLayout() {
        return cardLayout;
    }

    public javax.swing.JPanel getCardPanel() {
        return cardPanel;
    }

    public jaxx.runtime.swing.VBox getContent() {
        return content;
    }

    public javax.swing.JButton getCreateField() {
        return createField;
    }

    public javax.swing.JButton getCreateForm() {
        return createForm;
    }

    public javax.swing.JButton getDownloadTemplate() {
        return downloadTemplate;
    }

    public jaxx.runtime.swing.Table getFieldListUI() {
        return fieldListUI;
    }

    public jaxx.runtime.swing.HidorButton getHidorInfogene() {
        return hidorInfogene;
    }

    public javax.swing.JPanel getInfogene() {
        return infogene;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public javax.swing.JButton getNewTemplate() {
        return newTemplate;
    }

    public javax.swing.JButton getTemplateBindingButton() {
        return templateBindingButton;
    }

    public javax.swing.JComboBox getTemplateChoice() {
        return templateChoice;
    }

    public javax.swing.JButton getTemplateExampleButton() {
        return templateExampleButton;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(org.nuiton.wikitty.WikittyExtension newValue) {
        org.nuiton.wikitty.WikittyExtension oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldListUI, BorderLayout.CENTER);
        body.add(lastModified, BorderLayout.SOUTH);
    }

    protected void addChildrenToCardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        cardPanel.add(content, "content");
        cardPanel.add(infogene, "infogene");
    }

    protected void addChildrenToFieldListUI() {
        if (!allComponentsCreated) {
            return;
        }
        fieldListUI.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        fieldListUI.add($JPanel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        toolbar.add(createForm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCardLayout() {
        $objectMap.put("cardLayout", cardLayout = new jaxx.runtime.swing.CardLayout2());
    }

    protected void createCardPanel() {
        $objectMap.put("cardPanel", cardPanel = new javax.swing.JPanel());
        
        cardPanel.setName("cardPanel");
        cardPanel.setLayout(cardLayout);
    }

    protected void createContent() {
        $objectMap.put("content", content = new jaxx.runtime.swing.VBox());
        
        content.setName("content");
    }

    protected void createCreateField() {
        $objectMap.put("createField", createField = new javax.swing.JButton());
        
        createField.setName("createField");
        createField.setText(_("vradi.adminField.new"));
        createField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createField"));
    }

    protected void createCreateForm() {
        $objectMap.put("createForm", createForm = new javax.swing.JButton());
        
        createForm.setName("createForm");
        createForm.setText(_("vradi.adminForm.createForm"));
        createForm.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createForm"));
    }

    protected void createDownloadTemplate() {
        $objectMap.put("downloadTemplate", downloadTemplate = new javax.swing.JButton());
        
        downloadTemplate.setName("downloadTemplate");
        downloadTemplate.setText(_("vradi.adminFormType.template.download"));
        downloadTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__downloadTemplate"));
    }

    protected void createFieldListUI() {
        $objectMap.put("fieldListUI", fieldListUI = new jaxx.runtime.swing.Table());
        
        fieldListUI.setName("fieldListUI");
    }

    protected void createHidorInfogene() {
        $objectMap.put("hidorInfogene", hidorInfogene = new jaxx.runtime.swing.HidorButton());
        
        hidorInfogene.setName("hidorInfogene");
        hidorInfogene.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidorInfogene"));
    }

    protected void createInfogene() {
        $objectMap.put("infogene", infogene = new javax.swing.JPanel());
        
        infogene.setName("infogene");
        infogene.setLayout(new GridLayout(0,1));
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createNewTemplate() {
        $objectMap.put("newTemplate", newTemplate = new javax.swing.JButton());
        
        newTemplate.setName("newTemplate");
        newTemplate.setText(_("vradi.adminFormType.template.new"));
        newTemplate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newTemplate"));
    }

    protected void createTemplateBindingButton() {
        $objectMap.put("templateBindingButton", templateBindingButton = new javax.swing.JButton());
        
        templateBindingButton.setName("templateBindingButton");
        templateBindingButton.setText(_("vradi.adminFormType.template.fieldBinding"));
        templateBindingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateBindingButton"));
    }

    protected void createTemplateChoice() {
        $objectMap.put("templateChoice", templateChoice = new javax.swing.JComboBox());
        
        templateChoice.setName("templateChoice");
        templateChoice.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateChoice"));
    }

    protected void createTemplateExampleButton() {
        $objectMap.put("templateExampleButton", templateExampleButton = new javax.swing.JButton());
        
        templateExampleButton.setName("templateExampleButton");
        templateExampleButton.setText(_("vradi.adminFormType.template.showExample"));
        templateExampleButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__templateExampleButton"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToToolbar();
        addChildrenToBody();
        addChildrenToFieldListUI();
        // inline complete setup of $JPanel0
        $JPanel0.add(createField, BorderLayout.CENTER);
        $JPanel0.add(hidorInfogene, BorderLayout.WEST);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(cardPanel);
        addChildrenToCardPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(templateChoice);
        $JPanel1.add(newTemplate);
        $JPanel1.add(downloadTemplate);
        $JPanel1.add(templateBindingButton);
        $JPanel1.add(templateExampleButton);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        cardLayout.setUseOnlyVisibleComponentDimension(true);
        createField.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        hidorInfogene.setHideText(_("vradi.adminFormType.hideInfogene"));
        hidorInfogene.setShowText(_("vradi.adminFormType.showInfogene"));
        hidorInfogene.setTarget(new jaxx.runtime.swing.Spacer());
        hidorInfogene.setTargetVisible(false);
        templateChoice.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createBean();
        createCardLayout();
        createTitle();
        createCreateForm();
        createFieldListUI();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminField.title"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCreateField();
        createHidorInfogene();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createCardPanel();
        createContent();
        createInfogene();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminFormType.template.label"));
        createTemplateChoice();
        createNewTemplate();
        createDownloadTemplate();
        createTemplateBindingButton();
        createTemplateExampleButton();
        createLastModified();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEMPLATE_CHOICE_MODEL, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                templateChoice.setModel(getHandler().getTemplateComboBoxModel(getBean()));
            }
        });
    }

}