/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.TcpServer;
import org.h2.server.pg.PgServer;
import org.h2.server.web.WebServer;
import org.h2.util.StartBrowser;
import org.h2.util.Tool;

public class Server
extends Tool
implements Runnable,
ShutdownHandler {
    private Service service;
    private Server web;
    private Server tcp;
    private Server pg;
    private ShutdownHandler shutdownHandler;

    public Server() {
    }

    public Server(Service service, String ... stringArray) throws SQLException {
        this.service = service;
        try {
            service.init(stringArray);
        }
        catch (Exception exception) {
            throw Message.convert(exception);
        }
    }

    public static void main(String ... stringArray) throws SQLException {
        new Server().run(stringArray);
    }

    public void run(String ... stringArray) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = "";
        String string2 = "";
        boolean bl7 = true;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null) continue;
            if ("-?".equals(string3) || "-help".equals(string3)) {
                this.showUsage();
                return;
            }
            if (string3.startsWith("-web")) {
                if ("-web".equals(string3)) {
                    bl7 = false;
                    bl3 = true;
                    continue;
                }
                if ("-webAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-webSSL".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-webPort".equals(string3)) {
                    ++i;
                    continue;
                }
                if ("-webScript".equals(string3)) {
                    ++i;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if ("-browser".equals(string3)) {
                bl7 = false;
                bl4 = true;
                continue;
            }
            if (string3.startsWith("-tcp")) {
                if ("-tcp".equals(string3)) {
                    bl7 = false;
                    bl = true;
                    continue;
                }
                if ("-tcpAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-tcpSSL".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-tcpPort".equals(string3)) {
                    ++i;
                    continue;
                }
                if ("-tcpPassword".equals(string3)) {
                    string = stringArray[++i];
                    continue;
                }
                if ("-tcpShutdown".equals(string3)) {
                    bl7 = false;
                    bl5 = true;
                    string2 = stringArray[++i];
                    continue;
                }
                if ("-tcpShutdownForce".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) != 0) {
                        bl6 = Tool.readArgBoolean(stringArray, i) == 1;
                        ++i;
                        continue;
                    }
                    bl6 = true;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if (string3.startsWith("-pg")) {
                if ("-pg".equals(string3)) {
                    bl7 = false;
                    bl2 = true;
                    continue;
                }
                if ("-pgAllowOthers".equals(string3)) {
                    if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                    ++i;
                    continue;
                }
                if ("-pgPort".equals(string3)) {
                    ++i;
                    continue;
                }
                this.throwUnsupportedOption(string3);
                continue;
            }
            if ("-trace".equals(string3)) continue;
            if ("-log".equals(string3) && SysProperties.OLD_COMMAND_LINE_OPTIONS) {
                ++i;
                continue;
            }
            if ("-ifExists".equals(string3)) {
                if (Tool.readArgBoolean(stringArray, i) == 0) continue;
                ++i;
                continue;
            }
            if ("-baseDir".equals(string3)) {
                ++i;
                continue;
            }
            this.throwUnsupportedOption(string3);
        }
        if (bl7) {
            bl = true;
            bl2 = true;
            bl3 = true;
            bl4 = true;
        }
        if (bl5) {
            this.out.println("Shutting down TCP Server at " + string2);
            Server.shutdownTcpServer(string2, string, bl6);
        }
        if (bl3) {
            this.web = Server.createWebServer(stringArray);
            this.web.setShutdownHandler(this);
            SQLException sQLException = null;
            try {
                this.web.start();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.out.println(this.web.getStatus());
            if (bl4) {
                StartBrowser.openURL(this.web.getURL());
            }
            if (sQLException != null) {
                throw sQLException;
            }
        }
        if (bl) {
            this.tcp = Server.createTcpServer(stringArray);
            this.tcp.start();
            this.out.println(this.tcp.getStatus());
        }
        if (bl2) {
            this.pg = Server.createPgServer(stringArray);
            this.pg.start();
            this.out.println(this.pg.getStatus());
        }
    }

    public static void shutdownTcpServer(String string, String string2, boolean bl) throws SQLException {
        TcpServer.shutdown(string, string2, bl);
    }

    public String getStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isRunning(false)) {
            stringBuilder.append(this.service.getType()).append(" server running on ").append(this.service.getURL()).append(" (");
            if (this.service.getAllowOthers()) {
                stringBuilder.append("others can connect");
            } else {
                stringBuilder.append("only local connections");
            }
            stringBuilder.append(')');
        } else {
            stringBuilder.append("The ").append(this.service.getType()).append(" server could not be started. Possible cause: another server is already running on ").append(this.service.getURL());
        }
        return stringBuilder.toString();
    }

    public static Server createWebServer(String ... stringArray) throws SQLException {
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, stringArray);
        webServer.setShutdownHandler(server);
        return server;
    }

    public static Server createTcpServer(String ... stringArray) throws SQLException {
        return new Server(new TcpServer(), stringArray);
    }

    public static Server createPgServer(String ... stringArray) throws SQLException {
        return new Server(new PgServer(), stringArray);
    }

    public Server start() throws SQLException {
        this.service.start();
        Thread thread = new Thread(this);
        String string = this.service.getName() + " (" + this.service.getURL() + ")";
        thread.setName(string);
        thread.start();
        for (int i = 1; i < 64; i += i) {
            Server.wait(i);
            if (!this.isRunning(false)) continue;
            return this;
        }
        if (this.isRunning(true)) {
            return this;
        }
        throw Message.getSQLException(90061, string, "timeout");
    }

    private static void wait(int n) {
        try {
            long l = (long)n * (long)n;
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
    }

    public boolean isRunning(boolean bl) {
        return this.service.isRunning(bl);
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    public int getPort() {
        return this.service.getPort();
    }

    public void run() {
        try {
            this.service.listen();
        }
        catch (Exception exception) {
            TraceSystem.traceThrowable(exception);
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        } else {
            this.stopAll();
        }
    }

    public Service getService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startWebServer(Connection connection) throws SQLException {
        final Object object = new Object();
        WebServer webServer = new WebServer();
        Server server = new Server(webServer, "-webPort", "0");
        webServer.setShutdownHandler(new ShutdownHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shutdown() {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        });
        server.start();
        String string = webServer.addSession(connection);
        StartBrowser.openURL(string);
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        webServer.stop();
    }
}

