/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.SecurityTokenAbstract;
import org.nuiton.wikitty.SecurityTokenHelper;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyAuthorisationHelper;
import org.nuiton.wikitty.WikittyCopyOnWrite;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyGroupAbstract;
import org.nuiton.wikitty.WikittyGroupHelper;
import org.nuiton.wikitty.WikittyGroupImpl;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserHelper;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Search;

public class WikittyServiceSecurity
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceSecurity.class);
    public static final String WIKITTY_APPADMIN_GROUP_NAME = "WikittyAppAdmin";
    protected WikittyService ws;
    protected transient String appAdminGroupId = null;
    public static final String APPADMIN_LOGIN = "root";
    public static final String APPADMIN_PASSWORD = "toto";

    public WikittyServiceSecurity(WikittyService ws) {
        this.ws = ws;
        Wikitty appAdminGroup = this.getAppAdminGroup(null);
        if (WikittyGroupHelper.getMembers(appAdminGroup) == null) {
            ws.storeExtension(null, WikittyUserAbstract.extensions);
            ws.storeExtension(null, SecurityTokenAbstract.extensions);
            ws.storeExtension(null, WikittyGroupAbstract.extensions);
            WikittyImpl appAdmin = new WikittyImpl();
            WikittyUserHelper.addExtension(appAdmin);
            WikittyUserHelper.setLogin(appAdmin, APPADMIN_LOGIN);
            WikittyUserHelper.setPassword(appAdmin, APPADMIN_PASSWORD);
            ws.store(null, appAdmin);
            WikittyGroupHelper.addMembers(appAdminGroup, appAdmin.getId());
            ws.store(null, appAdminGroup);
            String adminToken = this.login(APPADMIN_LOGIN, APPADMIN_PASSWORD);
            this.logout(adminToken);
        }
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        this.ws.addWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        Wikitty user = this.ws.findByCriteria(null, Search.query().eq("WikittyUser.login", login).criteria());
        if (user == null) {
            throw new IllegalArgumentException(String.format("no such account '%s'", login));
        }
        if (WikittyUserHelper.getPassword(user).equals(password)) {
            String tokenId = WikittyUtil.genSecurityTokenId();
            WikittyImpl wikittyToken = new WikittyImpl(tokenId);
            SecurityTokenHelper.addExtension(wikittyToken);
            SecurityTokenHelper.setUser(wikittyToken, user.getId());
            this.ws.store(null, wikittyToken);
            log.debug((Object)String.format("token '%s' is for login '%s'", tokenId, login));
            return tokenId;
        }
        throw new SecurityException("bad password");
    }

    public void createAccount(String securityToken, String login, String password) {
        Wikitty user;
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            user = this.ws.findByCriteria(securityToken, Search.query().eq("WikittyUser.login", login).criteria());
            if (user != null) {
                throw new IllegalArgumentException(String.format("account already exists '%s'", login));
            }
        } else {
            throw new SecurityException("only admin can create accounts");
        }
        user = new WikittyImpl();
        WikittyUserHelper.addExtension(user);
        WikittyUserHelper.setLogin(user, login);
        WikittyUserHelper.setPassword(user, password);
        this.ws.store(null, user);
        log.debug((Object)String.format("login '%s' has userId '%s'", login, user.getId()));
    }

    public String getUserWikittyId(String securityToken, String login) {
        String userId = this.getUserId(securityToken);
        String userWikittyId = null;
        Wikitty user = this.ws.findByCriteria(null, Search.query().eq("WikittyUser.login", login).criteria());
        if (user != null) {
            userWikittyId = user.getId();
        }
        return userWikittyId;
    }

    @Override
    public void logout(String securityToken) {
        this.getUserId(securityToken);
        this.ws.delete(securityToken, securityToken);
    }

    @Override
    public void clear(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            throw new SecurityException(I18n._((String)"user %s can't clear data", (Object[])new Object[]{userId}));
        }
        this.ws.clear(securityToken);
    }

    protected String extensionToWikittySecurityId(WikittyExtension extension) {
        return String.format("WikittySecurity'%s'", extension.getName());
    }

    public Wikitty addWikittyAuthorisation(String securityToken, WikittyExtension extension) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            if (this.restoreExtensionAuthorisation(securityToken, extension) == null) {
                String wikittyAuthorisationId = this.extensionToWikittySecurityId(extension);
                WikittyImpl wikittyAuthorisation = new WikittyImpl(wikittyAuthorisationId);
                WikittyAuthorisationHelper.addExtension(wikittyAuthorisation);
                WikittyAuthorisationHelper.setOwner(wikittyAuthorisation, userId);
                this.ws.store(securityToken, wikittyAuthorisation);
                return wikittyAuthorisation;
            }
            throw new SecurityException(String.format("extension %s already has an security extension attached", extension.getName()));
        }
        throw new SecurityException(String.format("Only members of %s group can add authorisation", WIKITTY_APPADMIN_GROUP_NAME));
    }

    public Wikitty restoreExtensionAuthorisation(String securityToken, WikittyExtension extension) {
        String userId = this.getUserId(securityToken);
        String wikittyAuthorisationId = this.extensionToWikittySecurityId(extension);
        Wikitty wikittyAuthorisation = this.restore(securityToken, wikittyAuthorisationId);
        if (wikittyAuthorisation == null) {
            log.debug((Object)(extension + " has no authorization attached"));
        }
        return wikittyAuthorisation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void storeWikittyAuthorisation(String securityToken, Wikitty wikitty) {
        String userId = this.getUserId(securityToken);
        Wikitty oldVersion = this.ws.restore(null, wikitty.getId());
        if (!WikittyAuthorisationHelper.isExtension(wikitty)) throw new IllegalArgumentException(String.format("wikitty %s is not a wikittyAuthorisation. It misses the extension", wikitty));
        if (oldVersion == null) {
            throw new IllegalArgumentException("you can't store an authorisation for the fist time");
        }
        if (!this.canAdmin(securityToken, userId, oldVersion)) throw new SecurityException(String.format("user %s can't admin rights for this extension", userId));
        if (this.isAdmin(securityToken, userId, oldVersion)) {
            Object oldValue = oldVersion.getFieldAsObject("WikittyAuthorisation", "Owner");
            wikitty.setField("WikittyAuthorisation", "Owner", oldValue);
            WikittyAuthorisationHelper.setOwner(wikitty, WikittyAuthorisationHelper.getOwner(oldVersion));
            WikittyAuthorisationHelper.setParent(wikitty, WikittyAuthorisationHelper.getParent(oldVersion));
        }
        this.ws.store(null, wikitty);
    }

    protected boolean canRead(String securityToken, String userId, Wikitty extensionRights) {
        boolean canRead = this.isReader(securityToken, userId, extensionRights) || this.canWrite(securityToken, userId, extensionRights);
        return canRead;
    }

    protected boolean canWrite(String securityToken, String userId, Wikitty extensionRights) {
        boolean canWrite = this.isWriter(securityToken, userId, extensionRights) || this.isOwner(securityToken, userId, extensionRights) || this.isAppAdmin(securityToken, userId);
        return canWrite;
    }

    protected boolean canAdmin(String securityToken, String userId, Wikitty extensionRights) {
        boolean canWrite = this.isAdmin(securityToken, userId, extensionRights) || this.isOwner(securityToken, userId, extensionRights) || this.isAppAdmin(securityToken, userId);
        return canWrite;
    }

    protected boolean canDelete(String securityToken, String userId, Wikitty wikitty) {
        if (this.isAppAdmin(securityToken, userId)) {
            return true;
        }
        for (WikittyExtension extension : wikitty.getExtensions()) {
            Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extension);
            boolean canDelete = extensionRights == null || this.isOwner(securityToken, userId, extensionRights);
            if (canDelete) continue;
            return false;
        }
        return true;
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        Collection<Wikitty> wikitties = Arrays.asList(wikitty);
        wikitties = this.removeUnauthorizedModifications(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikitties);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        Collection<Wikitty> wikittiesToStore = this.removeUnauthorizedModifications(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikittiesToStore);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        Collection<Wikitty> wikittiesToStore = this.removeUnauthorizedModifications(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, wikittiesToStore, force);
        return result;
    }

    protected Collection<Wikitty> removeUnauthorizedModifications(String securityToken, Collection<Wikitty> wikitties) {
        String userId = this.getUserId(securityToken);
        ArrayList<Wikitty> wikittiesToStore = new ArrayList<Wikitty>();
        for (Wikitty wikitty : wikitties) {
            if (WikittyAuthorisationHelper.isExtension(wikitty)) {
                this.storeWikittyAuthorisation(securityToken, wikitty);
                continue;
            }
            Wikitty oldVersion = this.ws.restore(null, wikitty.getId());
            if (oldVersion == null) continue;
            for (WikittyExtension extension : wikitty.getExtensions()) {
                Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extension);
                if (extensionRights == null || this.canWrite(securityToken, userId, extensionRights)) continue;
                for (String fieldName : extension.getFieldNames()) {
                    if (oldVersion == null) {
                        wikitty.setField(extension.getName(), fieldName, null);
                        continue;
                    }
                    Object oldValue = oldVersion.getFieldAsObject(extension.getName(), fieldName);
                    wikitty.setField(extension.getName(), fieldName, oldValue);
                }
            }
            wikittiesToStore.add(wikitty);
        }
        return wikittiesToStore;
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        Collection<Wikitty> wikittiesToStore = this.removeUnauthorizedModifications(securityToken, wikitties);
        UpdateResponse result = this.ws.store(securityToken, transaction, wikittiesToStore, force);
        return result;
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        List<String> ids = Arrays.asList(id);
        List<Wikitty> wikitties = this.restore(securityToken, ids);
        Wikitty wikitty = null;
        if (!wikitties.isEmpty()) {
            wikitty = wikitties.get(0);
        }
        return wikitty;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>();
        for (String id : ids) {
            String userId = this.getUserId(securityToken);
            Wikitty wikitty = this.ws.restore(securityToken, id);
            if (wikitty == null) continue;
            wikitty = new WikittyCopyOnWrite(wikitty);
            for (WikittyExtension extension : wikitty.getExtensions()) {
                Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extension);
                boolean canRead = extensionRights == null || this.canRead(securityToken, userId, extensionRights);
                if (canRead) continue;
                for (String fieldName : extension.getFieldNames()) {
                    wikitty.setField(extension.getName(), fieldName, null);
                }
            }
            wikitties.add(wikitty);
        }
        return wikitties;
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String securityToken, String id) {
        List<String> ids = Arrays.asList(id);
        this.delete(securityToken, ids);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        ArrayList<String> idsAsList = new ArrayList<String>(ids);
        this.secureDelete(securityToken, idsAsList);
    }

    protected void secureDelete(String securityToken, List<String> ids) {
        String userId = this.getUserId(securityToken);
        List<Wikitty> wikitties = this.ws.restore(securityToken, ids);
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (Wikitty wikitty : wikitties) {
            if (!this.canDelete(securityToken, userId, wikitty)) continue;
            idsToRemove.add(wikitty.getId());
        }
        this.ws.delete(securityToken, idsToRemove);
    }

    @Override
    @Deprecated
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean canDelete(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean canRead(String securityToken, String wikittyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.ws.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.ws.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        List<WikittyExtension> exts = Arrays.asList(ext);
        return this.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        return this.ws.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        String userId = this.getUserId(securityToken);
        UpdateResponse response = null;
        if (this.isAppAdmin(securityToken, userId)) {
            response = this.ws.storeExtension(securityToken, transaction, exts);
        }
        return response;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return this.ws.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        return this.ws.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        return this.ws.restoreExtensionLastVersion(securityToken, transaction, name);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, criteria);
        return result;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        PagedResult<String> result = this.ws.findAllByCriteria(securityToken, transaction, criteria);
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        Wikitty result = this.ws.findByCriteria(securityToken, criteria);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public void addLabel(String securityToken, String wikittyId, String label) {
        this.ws.addLabel(securityToken, wikittyId, label);
    }

    @Override
    public PagedResult<String> findAllByLabel(String securityToken, String label, int firstIndex, int endIndex) {
        PagedResult<String> result = this.ws.findAllByLabel(securityToken, label, firstIndex, endIndex);
        return result;
    }

    @Override
    public Wikitty findByLabel(String securityToken, String label) {
        Wikitty result = this.ws.findByLabel(securityToken, label);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public Set<String> findAllAppliedLabels(String securityToken, String wikittyId) {
        Set<String> result = this.ws.findAllAppliedLabels(securityToken, wikittyId);
        return result;
    }

    @Override
    public Tree restoreTree(String securityToken, String wikittyId) {
        return this.ws.restoreTree(securityToken, wikittyId);
    }

    @Override
    public Map.Entry<TreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<TreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        return this.ws.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty result = this.ws.restoreVersion(securityToken, wikittyId, version);
        if (!this.canRead(securityToken, result.getId())) {
            result = null;
        }
        return result;
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            return this.ws.syncEngin(securityToken);
        }
        throw new SecurityException(I18n._((String)"user %s can't sync search engine", (Object[])new Object[]{this.getUserId(securityToken)}));
    }

    protected PagedResult<Wikitty> checkPagedResult(PagedResult<Wikitty> pagedResult) {
        return pagedResult;
    }

    protected String getUserId(String securityToken) {
        String result = null;
        Wikitty securityTokenWikitty = this.ws.restore(securityToken, securityToken);
        if (securityTokenWikitty == null) {
            throw new SecurityException(I18n._((String)"trying to use an invalidate security token %s", (Object[])new Object[]{securityToken}));
        }
        result = SecurityTokenHelper.getUser(securityTokenWikitty);
        return result;
    }

    protected boolean isAdmin(String securityToken, String userId, Wikitty extensionRights) {
        boolean result = this.isMember(securityToken, userId, extensionRights, "Admin");
        return result;
    }

    protected boolean isWriter(String securityToken, String userId, Wikitty extensionRights) {
        boolean result = this.isMember(securityToken, userId, extensionRights, "Writer");
        return result;
    }

    protected boolean isOwner(String securityToken, String userId, Wikitty extensionRights) {
        String owner = WikittyAuthorisationHelper.getOwner(extensionRights);
        boolean result = userId.equals(owner);
        return result;
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fieldName) {
        String parentId;
        Set<String> groupOrUser = extensionRights.getFieldAsSet("WikittyAuthorisation", fieldName, String.class);
        boolean result = this.isMember(securityToken, userId, groupOrUser);
        if (!result && (parentId = WikittyAuthorisationHelper.getParent(extensionRights)) != null) {
            Wikitty parent = this.ws.restore(securityToken, parentId);
            result = this.isMember(securityToken, userId, parent, fieldName);
        }
        return result;
    }

    protected boolean isReader(String securityToken, String userId, Wikitty w) {
        boolean result = true;
        if (WikittyAuthorisationHelper.isExtension(w)) {
            Set<String> groupOrUser = WikittyAuthorisationHelper.getReader(w);
            if (groupOrUser == null || groupOrUser.size() == 0) {
                String parentId = WikittyAuthorisationHelper.getParent(w);
                if (parentId != null) {
                    Wikitty parent = this.ws.restore(securityToken, parentId);
                    result = this.isReader(securityToken, userId, parent);
                }
            } else {
                result = this.isMember(securityToken, userId, w, "Reader");
            }
        }
        return result;
    }

    protected boolean isAppAdmin(String securityToken, String userId) {
        Wikitty group = this.getAppAdminGroup(securityToken);
        Set<String> ids = WikittyGroupHelper.getMembers(group);
        boolean result = this.isMember(securityToken, userId, ids);
        return result;
    }

    protected Wikitty getAppAdminGroup(String securityToken) {
        Wikitty group = this.appAdminGroupId == null ? this.ws.findByCriteria(securityToken, Search.query().eq("WikittyGroup.name", WIKITTY_APPADMIN_GROUP_NAME).criteria()) : this.ws.restore(securityToken, this.appAdminGroupId);
        if (group == null) {
            WikittyGroupImpl appAdminGroup = new WikittyGroupImpl();
            appAdminGroup.setName(WIKITTY_APPADMIN_GROUP_NAME);
            this.ws.store(securityToken, appAdminGroup.getWikitty());
            group = appAdminGroup.getWikitty();
            this.appAdminGroupId = group.getId();
        }
        return group;
    }

    protected boolean isMember(String securityToken, String userId, Set<String> groupOrUser) {
        if (groupOrUser != null) {
            for (String id : groupOrUser) {
                if (userId.equals(id)) {
                    return true;
                }
                Wikitty groupWikitty = this.ws.restore(securityToken, id);
                if (!WikittyGroupHelper.isExtension(groupWikitty)) continue;
                Set<String> members = WikittyGroupHelper.getMembers(groupWikitty);
                return this.isMember(securityToken, userId, members);
            }
        }
        return false;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        return null;
    }

    @Override
    public List<String> deleteTree(String securityToken, String treeNodeId) {
        return null;
    }
}

