/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WHScrollBarUI
extends BasicScrollBarUI {
    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (this.scrollbar != null) {
            this.scrollbar.setPreferredSize(this.scrollbar.getOrientation() == 0 ? new Dimension(1, 14) : new Dimension(14, 1));
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new WHScrollBarUI();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        int w = c.getWidth();
        int h = c.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gp = this.scrollbar.getOrientation() == 1 ? new GradientPaint(0.0f, 0.0f, new Color(215, 212, 207), w - 1, 0.0f, new Color(234, 232, 228), false) : new GradientPaint(0.0f, 0.0f, new Color(215, 212, 207), 0.0f, h - 1, new Color(234, 232, 228), false);
        g2.setPaint(gp);
        g2.fillRect(0, 0, w, h);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gp = this.scrollbar.getOrientation() == 1 ? new GradientPaint(1.0f, 0.0f, new Color(212, 208, 200), w - 1, 0.0f, new Color(187, 182, 171), true) : new GradientPaint(0.0f, 1.0f, new Color(212, 208, 200), 0.0f, h - 1, new Color(187, 182, 171), true);
        g2.setPaint(gp);
        g2.fillRect(thumbBounds.x, thumbBounds.y, w - 1, h - 1);
        g2.setColor(new Color(126, 124, 120));
        g2.drawRoundRect(thumbBounds.x, thumbBounds.y, w - 1, h - 1, 4, 4);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.scrollbar.getOrientation() == 1) {
            int hh = thumbBounds.y + thumbBounds.height / 2 - 1;
            g.setColor(new Color(182, 179, 171));
            g.drawLine(4, hh, 8, hh);
            g.drawLine(4, hh + 3, 8, hh + 3);
            g.drawLine(4, hh - 3, 8, hh - 3);
            g.setColor(new Color(229, 227, 222));
            g.drawLine(5, hh + 1, 9, hh + 1);
            g.drawLine(5, hh + 4, 9, hh + 4);
            g.drawLine(5, hh - 2, 9, hh - 2);
        } else {
            int ww = thumbBounds.x + thumbBounds.width / 2 - 1;
            g.setColor(new Color(182, 179, 171));
            g.drawLine(ww, 4, ww, 8);
            g.drawLine(ww + 3, 4, ww + 3, 8);
            g.drawLine(ww - 3, 4, ww - 3, 8);
            g.setColor(new Color(229, 227, 222));
            g.drawLine(ww + 1, 5, ww + 1, 9);
            g.drawLine(ww + 4, 5, ww + 4, 9);
            g.drawLine(ww - 2, 5, ww - 2, 9);
        }
    }

    private JButton createButton(final boolean isDecrease) {
        JButton button = new JButton(){

            @Override
            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = WHScrollBarUI.this.scrollbar.getOrientation() == 1 ? new GradientPaint(1.0f, 0.0f, new Color(187, 182, 171), w - 1, 0.0f, new Color(212, 208, 200), true) : new GradientPaint(0.0f, 1.0f, new Color(187, 182, 171), 0.0f, h - 1, new Color(212, 208, 200), true);
                g2.setPaint(gp);
                g2.fillRect(0, 0, w, h);
                g.setColor(new Color(85, 83, 79));
                g2.drawRoundRect(0, 0, w - 1, h - 1, 4, 4);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setColor(Color.black);
                if (WHScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (isDecrease) {
                        g.drawLine(7, 5, 7, 5);
                        g.drawLine(6, 6, 8, 6);
                        g.drawLine(5, 7, 9, 7);
                        g.drawLine(4, 8, 10, 8);
                    } else {
                        g.drawLine(7, 8, 7, 8);
                        g.drawLine(6, 7, 8, 7);
                        g.drawLine(5, 6, 9, 6);
                        g.drawLine(4, 5, 10, 5);
                    }
                } else if (isDecrease) {
                    g.drawLine(5, 7, 5, 7);
                    g.drawLine(6, 6, 6, 8);
                    g.drawLine(7, 5, 7, 9);
                    g.drawLine(8, 4, 8, 10);
                } else {
                    g.drawLine(8, 7, 8, 7);
                    g.drawLine(7, 6, 7, 8);
                    g.drawLine(6, 5, 6, 9);
                    g.drawLine(5, 4, 5, 10);
                }
            }
        };
        button.setPreferredSize(new Dimension(14, 14));
        return button;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createButton(true);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createButton(false);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(14, 14);
    }
}

