package com.jurismarches.vradi.ui.renderers;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

/**
 * NumberListCellRenderer.
 * 
 * Display a special string for "-1" value;
 *
 * @author schorlet
 * @version $Revision: 1161 $ $Date: 2010-07-26 15:43:04 +0200 (lun., 26 juil. 2010) $
 * @since 24 mars 2010 12:26:58
 */
public class NumberListCellRenderer extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {
        
        Number number = (Number)value;
        Object newValue = number;

        // -1 means no search restriction
        if (number.intValue() == -1) {
            newValue = _("vradi.common.alls");
        }

        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                cellHasFocus);
    }
}
