/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.ui.renderers;

import com.jurismarches.vradi.VradiHelper;

import java.awt.*;
import java.util.Map;

/**
 *
 * All renderer instance can use the singleton to render thesaurus
 *
 * @author letellier
 */
public class ColorsMap {

    protected Map<Integer, Color> colors;
    private static ColorsMap instance = null;

    public ColorsMap() {
        updateColors();
    }

    public static ColorsMap getInstance() {
        if (instance == null) {
            instance = new ColorsMap();
        }
        return instance;
    }

    public void updateColors() {
        colors = VradiHelper.getColorsThesaurus();
    }

    public Color get(int depth) {
        return colors.get(depth);
    }
}

