package com.jurismarches.vradi.ui.offer.thesaurus.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author letellier
 */
public class RootThesaurusNodeLoadors extends NavTreeNodeChildLoador<String, RootThesaurus, VradiTreeNode> {

    /** Logger */
    static private final Log log =
            LogFactory.getLog(RootThesaurusNodeLoadors.class);

    public RootThesaurusNodeLoadors() {
        super(RootThesaurus.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) {

        List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.getAllRootThesaurus();

        Collections.sort(rootThesaurusList, VradiComparators.ROOT_THESAURUS_COMPARATOR);

        // Return children
        return extractIds(rootThesaurusList);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {

        if (log.isDebugEnabled()) {
            log.debug("[Root loador] creating thesaurus " + id);
        }

        return new VradiTreeNode(
                    getBeanType(),
                    id,
                    null,
                    NavHelper.getChildLoador(ThesaurusNodeLoadors.class)
            );
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        List<String> ids = new ArrayList<String>();
        for (BusinessEntity e : entities) {
            ids.add(e.getWikittyId());
        }
        return ids;
    }
}