package com.jurismarches.vradi.ui.offer.thesaurus;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.thesaurus.*;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusTreeHelper;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ThesaurusUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_MODEL = "thesaurus.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTree thesaurus;
    protected javax.swing.JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected DefaultListModel thesaurusSelectedModel;
    protected ThesaurusSelectionManager manager;
    protected ThesaurusTreeHelper helper;
    protected boolean deletable;
    
    
    public  ThesaurusUI(JAXXContext parentContext, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        jaxx.runtime.SwingUtil.initContext(this, parentContext);
        this.deletable = deletable;
        this.helper = helper;
        this.manager = manager;
    $initialize();
    }
    
    public OfferEditUI getParentUI(){
        return getParentContainer(OfferEditUI.class);
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    void $afterCompleteSetup() {
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
                    JMenuItem menuAddCriteria = new JMenuItem();
                    menuAddCriteria.setText(_("vradi.menu.addCriteria"));
                    menuAddCriteria.addActionListener(new ActionListener() {
    
                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            addCriteriaSelected(getPathSelected(mouseEvent));
                        }
                    });
                    popup.add(menuAddCriteria);
    
    //                JMenuItem menuAddColumns = new JMenuItem();
    //                menuAddColumns.setText(_("vradi.menu.addColumns"));
    //                menuAddColumns.addActionListener(new ActionListener() {
    //
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addColumnSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesaurusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
                    }
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        };
        thesaurus.addTreeSelectionListener(selectionListener);
    
        // Expends root
        thesaurus.expandRow(0);
    
        // Override default selection model to enable one click selection
        thesaurus.setSelectionModel(new DefaultTreeSelectionModel() {
    
            @Override
            public void setSelectionPath(TreePath path) {
                TreePath[] treePaths = getSelectionPaths();
                if (treePaths == null || !Arrays.asList(treePaths).contains(path)) {
                    addSelectionPath(path);
                } else {
                    removeSelectionPath(path);
                }
            }
        });
    
        // If not root thesaurusUI
        if (deletable) {
            manager.registerTreeHelper(helper, thesaurus);
        } else {
            manager.registerRootTreeHelper(helper, thesaurus);
        }
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        jaxx.runtime.JAXXUtil.assignment(thesaurusSelectedModel = new DefaultListModel(), "thesaurusSelectedModel", com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI.this);
        if (treePaths != null){
            for (TreePath path : treePaths){
                VradiTreeNode selected = (VradiTreeNode)path.getLastPathComponent();
                if (selected.getInternalClass().equals(Thesaurus.class)) {
                    Thesaurus thesaurusSelected = ThesaurusDataHelper.restoreThesaurus(selected.getId());
                    thesaurusSelectedModel.addElement(thesaurusSelected);
                }
    
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent mouseEvent){
        JTree tree = (JTree) mouseEvent.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesaurusSelected(TreePath path){
        log.debug("addThesaurusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().newThesaurusUI(this, manager, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
    //    getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = getHandler().getNamePath(helper.getRootNode());
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTree getThesaurus() {
        return thesaurus;
    }

    public javax.swing.JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JTree());
        
        thesaurus.setName("thesaurus");
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new javax.swing.JList());
        
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setCellRenderer(new ThesaurusHighlighter());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("thesaurusUI", this);
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(getHandler().getNamePath(helper.getRootNode())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(deletable);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setModel(helper.createTreeModel());
                }
            }
        });
    }

}