package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class UrlEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, UrlEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm9jBCeEjFlYighQgEgikNTQ0QRAIWBA5gDCJItyw9m3ijfZul9295EKB+An8BOhpkOioEAU1BQ3iLyBEQYuYvXN8NlzACBd71sy8N2/fzrz8AgWj4cQmjSKiw8Byn5Glq2trd1qbrG2vM9PWXFmpIfnl8pBvwrjXixsLp5p1B6924dVF6SsZsKAPPV+HMWN3BDMdxqyF44OItjHVRi89H6lQ77L2RGWxPv/2Nf/Me/oiDxApVFfEq8z+DZXeZKQOee5ZmMROW7QqaLCBMjQPNlDvhIstCmrMbeqzR/AERutQVFQjmYWTw1855ojxkbIwMbeqqcdveBxrzlu40JY+2Qw1Nz7V7Q4zZMvlSciJXF9nmrC40pAVLRKQUjFb0ULBlx4TFi7+M8eyA6ZEpS0quEcxYeHcgH+9BDHb6AtpuHN1N5gyTCQtFmVgY38mnXtRF7R0lwb97YpJsYXKQNV9FtkaZ8JzZZOpuLmla6G1MkC3ygOAJNyt1nBsQDnOFElnKn30XBMKOsSwhanm72N4D1PJAE79MoCOMM7+qJQ/vvn8utY/dUczS/uWBqdBaamYtty1PpSMXGi5qC5TNd+EkmECNy7eqJkMYY1uGsVhvyMOThyc3KSmgxSF0U9v31UeftgH+RqMCUm9GnX1t6BkOxpdkMKL1JWFWNGB7f14Hnba8DkE3ZFoJRy8hK9KZ1s88NDfyxGaMJNhQk9Jq/T+e7nxamHXiBwKm96zPDWj8ACKPBA8YPECdncrc+HGlWGhJ9MdytqqnPuWVXfAZuNzLuum4z6NuB/6Df44bnA6Ct3nTKzd/Ts7JJULkz8wVIYSw4MhxAxDNWJxdf6Xg7eTXdqDYxo5fgJJa3wOLgYAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.UrlEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField editor;
    protected com.jurismarches.vradi.ui.offer.editors.UrlEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private UrlEditor $VradiEditor0 = this;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
        validator.setBean(model);
        getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                .registerValidator(validator);
    }
    
    protected void browseURI() {
        try {
            UIHelper.browseURI(editor.getText().trim());
        } catch (IOException eee){
            log.error("Cannot display URL : " + editor.getText().trim());
            JOptionPane.showMessageDialog(null,
                    _("message.cannot.display.url"));
    
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UrlEditor() {
        super();
        $initialize();
    }

    public UrlEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        browseURI();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.offer.editors.UrlEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JButton0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
        validator.setFieldRepresentation("value", editor);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.UrlEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.UrlEditorModel >(com.jurismarches.vradi.ui.offer.editors.UrlEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        ((javax.swing.JPanel) editorContent).setMaximumSize(new Dimension(0, 28));
        editor.setMaximumSize(new Dimension(Integer.MAX_VALUE,28));
        editor.setMinimumSize(new Dimension(0,28));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("site"));
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}