/*
 * *##%
 * Vradi :: Swing
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.ui.helpers;

import static org.nuiton.i18n.I18n._;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.*;

import javax.swing.*;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.models.FormTypeModel;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.renderers.VradiI18nTableCellRenderer;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;

import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.wikitty.BusinessEntity;

import au.com.bytecode.opencsv.CSVWriter;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusHandler;
import com.jurismarches.vradi.ui.models.EntityModel;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Classe de méthodes utiles pour les ui.
 * <p/>
 * User: chemit
 * Date: 23 nov. 2009
 * Time: 11:51:14
 */
public class UIHelper extends SwingUtil {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(UIHelper.class);


    private UIHelper() {
        // pas d'instance
    }

    /**
     * Met à jour le modèle de sélection {@code list} donnée avec l'objet {@code value} entrant.
     * <p/>
     * {@code value} represente normalement une collection de données.
     *
     * @param list  la liste à updater
     * @param value la liste des valeurs de la selection de la liste.
     */
    public static void updateListSelection(JList list, Object value) {

        list.setValueIsAdjusting(true);
        list.clearSelection();

        try {
            if (value != null) {

                // la valeur doit être une collection, on met a jour le model de selection
                int size = list.getModel().getSize();
                Collection<?> valuesToSelect = (Collection<?>) value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; i++) {
                        Object o = list.getModel().getElementAt(i);
                        if (o.equals(v)) {
                            indexToSelect[index++] = i;
                            break;
                        }
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("index to select = " + Arrays.toString(indexToSelect));
                }
                list.setSelectedIndices(indexToSelect);
            }

        } finally {

            list.setValueIsAdjusting(false);
        }
    }

    // I18n
    public static void setI18nTableHeaderRenderer(JTable table, String... libelles) {
        table.getTableHeader().setDefaultRenderer(new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles));
    }

    public static void openAddressInBrowser(String address) {
        if(address != null) {
            try {
                browseURI("http://maps.google.fr/maps?f=q&source=s_q&hl=fr&geocode=&q="
                    + getStringValue(address) + ",France");
            } catch (IOException eee) {
                log.error("Cant display page for address : " +
                        getStringValue(address), eee);
                JOptionPane.showMessageDialog(null,
                        _("message.cannot.display.address"));

            }
        }
    }

    public static void browseURI(URI uri) throws IOException {
        if(uri != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Browse URI : " + uri.toString());
                }
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(uri);
        }
    }

    public static void browseURI(String uri) throws IOException {
        if(uri != null) {
            try {
                browseURI(new URI(uri.replace(" ", "+")));
            } catch (URISyntaxException eee) {
                log.error("Cant display uri : " + uri, eee);
                ErrorDialogUI.showError(eee);
            }
        }
    }

    public static void browseURI(URL url) throws IOException {
        if(url != null) {
            String externalForm = url.toExternalForm();
            browseURI(externalForm);
        }
    }
    
    public static void createEmail(String emailAdress)
            throws IOException, URISyntaxException, UnsupportedOperationException {
        URI mailtoURI = new URI("mailto:" + emailAdress);
        Desktop.getDesktop().mail(mailtoURI);
    }

    public static void exportToCSV(File file, OfferListTableModel model) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            CSVWriter csvWriter = new CSVWriter(fileWriter);

            int columnCount = model.getColumnCount();
            String[] nextLine = new String[columnCount];
            
            // writes headers
            for (int i = 0; i < model.getColumnCount(); i++) {
                nextLine[i] = _(model.getColumnName(i));
            }
            csvWriter.writeNext(nextLine);
            
            // writes row values
            for (int i = 0; i < model.getRowCount(); i++) {
                nextLine = new String[columnCount];
                
                for (int j = 0; j < model.getColumnCount(); j++) {
                    Object valueAt = model.getValueAt(i, j);
                    if (valueAt != null) {
                        String value = String.valueOf(valueAt);
                        nextLine[j] = value;
                    }
                }
                csvWriter.writeNext(nextLine);
                
            }
            csvWriter.close();

        } catch (IOException e) {
            log.error(e.getMessage(), e);
            ErrorDialogUI.showError(e);
        }
    }

    public static File openFileChooser(final String fileExtension, final String description, final Component component,
                                       String validationLabel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter() {

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }

                String ext = null;
                String fileName = file.getName();
                int dot = fileName.lastIndexOf('.');

                if (dot > 0 && dot < fileName.length() - 1) {
                    ext = fileName.substring(dot).toLowerCase();
                }
                return ext != null && ext.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return _(description);
            }
        });

        int returnVal = fileChooser.showDialog(component, _(validationLabel));
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(fileExtension)) {
                file = new File(file.getAbsolutePath() + fileExtension);
            }
            log.debug("saving : " + file.getName() + ".");
            return file;
        } else {
            log.debug("No file chosen by user.");
            return null;
        }
    }

    public static ListCellRenderer getTranslationListCellRenderer() {
        return new DefaultListCellRenderer() {

            @Override
            public Component getListCellRendererComponent(
                    JList list,
                    Object value,
                    int index,
                    boolean isSelected,
                    boolean cellHasFocus) {
                if (value != null) {
                    return super.getListCellRendererComponent(list, _(value.toString()), index,
                            isSelected, cellHasFocus);
                } else {
                    return super.getListCellRendererComponent(list, value, index,
                            isSelected, cellHasFocus);
                }
            }

        };
    }

    public static <T> T getHandler(JAXXContext context, Class<T> handlerClass) {
        T handler = context.getContextValue(handlerClass);
        if (handler != null) {
            return handler;
        }
        try {
            handler = handlerClass.newInstance();
        } catch (InstantiationException e) {
            log.error("Cant create handler instance of type " + handlerClass.getName() + " : ", e);
            ErrorDialogUI.showError(e);
        } catch (IllegalAccessException e) {
            log.error("Cant create handler instance of type " + handlerClass.getName() + " : ", e);
            ErrorDialogUI.showError(e);
        }

        if (context instanceof JAXXInitialContext) {
            ((JAXXInitialContext) context).add(handler);
        } else {
            context.setContextValue(handler);
        }
        return handler;
    }

    public static ComboBoxModel getNumberComboBoxModel(int startIndex, int nbData) {
        Object[] data = new Integer[nbData];
        for (int i = startIndex; i < data.length; i++) {
            data[i] = i;
        }
        return new DefaultComboBoxModel(data);
    }

    public static ComboBoxModel getNumberComboBoxModel(int nbData) {
        return getNumberComboBoxModel(0, nbData);
    }

    public static ComboBoxModel getHourModel() {
        return getNumberComboBoxModel(24);
    }

    public static ComboBoxModel getMinuteModel() {
        return getNumberComboBoxModel(60);
    }

    public static ListCellRenderer get2DigitsRenderer() {
        return new DefaultListCellRenderer() {

            @Override
            public Component getListCellRendererComponent(JList jList, Object o,
                                                          int i, boolean b, boolean b1) {

                String value = null;
                if(o != null) {
                    value = (Integer) o < 10 ? "0" + o.toString() : o.toString();
                }
                return super.getListCellRendererComponent(jList, value, i, b, b1);
            }
        };
    }

    public static ListCellRenderer getTranslationRenderer() {
        return new DefaultListCellRenderer() {

            @Override
            public Component getListCellRendererComponent(JList jList, Object o,
                                                          int i, boolean b, boolean b1) {
                String value = null;
                if(o != null) {
                    value = o.toString();
                }
                return super.getListCellRendererComponent(jList, _(value), i, b, b1);
            }
        };
    }

    public static WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    public static VradiDataService getDataService() {
        return VradiService.getVradiDataService();
    }

    public static EntityModel getXmlStreamsModel() {
        List<XmlStream> streamList = getDataService().findAllXmlStreams();
        return new EntityModel<XmlStream>(XmlStream.class, XmlStream.EXT_XMLSTREAM, streamList);
    }

    public static ListModel getStatusesModel(boolean firstNull) {
        List<Status> status = AdminHandler.getAllStatuses();
        return new EntityModel<Status>(Status.class, Status.EXT_STATUS, status, firstNull);
    }

    public static ListCellRenderer getStatusCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Status status = (Status)value;
                return super.getListCellRendererComponent(list, _(status.getName()), index, isSelected, cellHasFocus) ;
            }
        };
    }

    public static ComboBoxModel getFormTypesModel() {
        return new FormTypeModel(false);
    }

    public static ComboBoxModel getFormTypesModel(boolean firstNull) {
        return new FormTypeModel(firstNull);
    }

    public static <E extends BusinessEntity> ComboBoxModel getQueryMakersModel(Class<E> clazz, String ext, List<E> entities) {
        if (entities == null){
            return new DefaultComboBoxModel();
        }
        return new EntityModel<E>(clazz, ext, entities, false);
    }

    public static ListModel getSendingModel(Map<?, Sending> entity) {
        if (entity == null){
            return new DefaultListModel();
        }

        List<Sending> datas = new ArrayList<Sending>(entity.values());
        return new EntityModel<Sending>(Sending.class, Sending.EXT_SENDING, datas, false);
    }

    /**
     * Get content if exist in content, else return null
     */
    @SuppressWarnings({"unchecked"})
    public static <E extends Component> E getContentIfExist(CardLayout2 contentLayout, JPanel content, Class<E> uiClass) {
        String contentName = uiClass.getName();
        if (log.isDebugEnabled()) {
            log.debug("Get content if exist " + contentName);
        }
        if (!contentLayout.contains(contentName)) {
            return null;
        }
        return (E)contentLayout.getComponent(content, contentName);
    }

    /**
     * NumberFormatterFactory creates a new NumberFormatter for Integer of variable length.
     */
    public static class NumberFormatterFactory extends JFormattedTextField.AbstractFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setAllowsInvalid(false);
            numberFormatter.setValueClass(Integer.class);
            return numberFormatter;
        }
    }
          
    public static void openFormPopup(JAXXContext context, Form form) {
        // add the form to the context
        context.setContextValue(form);
        //get the OfferEditUI instance from the context
        OfferEditUI ui = context.getContextValue(OfferEditUI.class,
                "formPopupOfferEditUI");
        // if the instance has not yet been created, create it
        if(ui == null) {
            ui = new OfferEditUI(context);
            context.setContextValue(ui, "formPopupOfferEditUI");
        }
        // remove all the field editors from the ui
        ui.getContent().removeAll();

        OfferEditHandler handler = getHandler(context, OfferEditHandler.class);
        //add the editors for our form
        handler.fillfields(ui, form);
        // init the thesaurus for our form
        getHandler(context, ThesaurusHandler.class).initThesaurus(ui);

        //get the JDialog instance from the context
        JDialog frame = context.getContextValue(JDialog.class, "formPopup");
        // if the instance has not yet been created, create it
        if(frame == null) {
            JDialog parent = null;
            Component c = (Component) context;
            while(parent == null && c != null) {
                if(JDialog.class.isAssignableFrom(c.getClass())) {
                    parent = (JDialog) c;
                } else {
                    c = c.getParent();
                }
            }
            frame = new JDialog(parent);
            frame.setLayout(new BorderLayout());
            frame.setSize(new Dimension(800, 800));
            frame.getContentPane().add(ui, BorderLayout.CENTER);
            context.setContextValue(frame, "formPopup");
        }
        // change the title
        frame.setTitle(form.getObjet());
        // set the frame visible, in case it has been hidden
        frame.setVisible(true);
    }

    /**
     * Wait node appair to select it
     *
     * @param helper helper to select node
     * @param id to select
     */
    public static void selectNodeLater(final NavHelper helper, final String id) {
        SwingUtilities.invokeLater(new Thread() {

            @SuppressWarnings({"unchecked"})
            @Override
            public void run() {
                NavNode node = helper.findNode(helper.getRootNode(), id);
                while (node == null) {
                    try {
                        wait(100);
                    } catch (InterruptedException eee) {
                        log.error("Cant select node with id : " + id, eee);
                        ErrorDialogUI.showError(eee);
                    }
                    node = helper.findNode(helper.getRootNode(), id);
                }
                helper.selectNode(node);
            }
        });
    }

    /**
     * Wait node appair to select it
     *
     * @param helper helper to select node
     * @param id to select
     */
    public static void refreshNodeLater(final AdminNavigationTreeHelper helper, final String id) {

        // Keep selected
        final String selectedNodeID = helper.getSelectedNode() == null ? null : helper.getSelectedNode().getId();

        SwingUtilities.invokeLater(new Thread() {

            @SuppressWarnings({"unchecked"})
            @Override
            public void run() {
                VradiTreeNode node = helper.findNode(helper.getRootNode(), id);
                while (node == null) {
                    try {
                        wait(100);
                    } catch (InterruptedException eee) {
                        log.error("Cant select node with id : " + id, eee);
                        ErrorDialogUI.showError(eee);
                    }
                    node = helper.findNode(helper.getRootNode(), id);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Refresh node " + node.getId() + " with internal class " + node.getInternalClass());
                }
                // Refresh
                helper.refresh(node);

                // Restore selected
                VradiTreeNode selectedNode = helper.findNode(helper.getRootNode(), selectedNodeID);

                if (selectedNode != null) {
                    String id = selectedNode.getId();
                    if (id.contains("category")){
                        // if going to category, reselect node because
                        // id changed
                        helper.reSelectCategory(selectedNode);
                    } else {
                        helper.selectNode(selectedNode);
                    }
                }
            }
        });
    }

    /**
     * Add a listener of tree selection model to expand a new selected node
     * when it is selected.
     *
     * @param tree the tree to treate
     */
    public static void addThesaurusExpandOnClickListener(final JTree tree) {

        tree.getSelectionModel().addTreeSelectionListener(
            new TreeSelectionListener() {

            @Override
            public void valueChanged(final TreeSelectionEvent e) {

                boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();

                if (!isThesaurusExpanded) {
                    return;
                }

                TreeNode node = (TreeNode)
                        e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {

                    SwingUtilities.invokeLater(new Runnable() {

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (e.isAddedPath(path) &&
                                    !tree.isExpanded(path)) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("expand node [" + path
                                             + "]");
                                    }

                                    // will expand the node
                                    tree.expandPath(path);
                                }
                            }
                        }
                    });
                }
            }
        });
    }
    
    /**
     * Add a listener of tree selection model to expand a new selected node
     * when it is selected.
     *
     * @param treeTable the treeTable to treate
     */
    public static void addThesaurusExpandOnClickListener(final JXTreeTable treeTable) {

        treeTable.addTreeSelectionListener(
            new TreeSelectionListener() {

            @Override
            public void valueChanged(final TreeSelectionEvent e) {

                TreeNode node = (TreeNode)
                        e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {

                    SwingUtilities.invokeLater(new Runnable() {

                        @Override
                        public void run() {
                            boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();
                            for (TreePath path : e.getPaths()) {
                                if (e.isAddedPath(path) &&
                                    !treeTable.isExpanded(path)) {

                                    if (log.isDebugEnabled()) {
                                        log.debug("expand node [" + path
                                             + "]");
                                    }
                                    
                                    if (isThesaurusExpanded) {

                                        treeTable.expandPath(path);
                                    }

                                    // Keep selection
                                    treeTable.getTreeSelectionModel().setSelectionPath(path);
                                }
                            }
                        }
                    });
                }
            }
        });
    }
}
