package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class EmailUsersNodeLoadors extends AbstractEmailNodeLoador<User> {

    public EmailUsersNodeLoadors() {
        super(User.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract clients ids
        List<String> userIds = new ArrayList<String>();
        for (Sending sending : sendings) {
            userIds.add(sending.getUser());
        }

        // Sort
        List<User> userSorted = VradiService.getWikittyProxy().restore(User.class, userIds);
        Collections.sort(userSorted,  VradiComparators.USER_COMPARATOR);

        // Return clients
        return extractIds(userSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}
