package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.*;
import com.jurismarches.vradi.ui.email.helpers.EmailNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SessionsListUI extends com.jurismarches.vradi.ui.email.EmailContentUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_SESSION = "selectedSession";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HEADER_PANEL_VISIBLE = "headerPanel.visible";
    public static final String BINDING_SESSION_PARAGRAPH_TEXT = "sessionParagraph.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVtpSoFAgIIYfgtToaYtGjQkEQZRAU5VYNMRenHYn7ZDp7jgzC8vF+Cf4J+jdi4k3T8aDZw9ejP+CMR68Gt/sLtsuLtCEHna7b773ve+9ee+9+4lSUqC5Xey6hnAsRVvEKK3u7Dyq7ZK6ukdkXVCubIH8XyKJklXUb4Z2qdB8tazdi4F7cc1ucdsiVof3Yhn1SXXAiGwSohSajnrUpSxWwuNFlzvikDUUFcf65vev5Gvz1dskQi4HdQOQyuxpXu1MesooSU2FRiDSHi4ybDVAhqBWA/TmtG2NYSkf4hZ5gV6iTBmlORZAptCl7lP2ODx/lyuUL9xvYcrWbEsB/MnmgkJG3W4Zu46gsoVFvUmksSewSQ2HGkRjjQqRktqWLFMJHpx7bGmFhiRhcEnEDAAKXTmGCkJRReEzQLY5+psEm0RsYYswqIRO2jXkPtTAKHlGjcuG8ExhG9cYAdUTkTr7Ht6ZRg6FDr2FUhnXCFs4Su5ZNWikE+uFXNDfw9GzXGGDmra46yhlW0A2ExO+AxF1HpN+2ltY4IbAvBlmNhxVmyuUKnVhM6YBEOV8RHL7SMOnQ6/8UXqIGHHcJq5aFQRr/MX4YNe0cS5a7MGAN2iWUO9lDn0+GSkATJDRnqB2iyeqKCUcMMOFVf8fusdw5I/bxJFx04Te6d/x0W8ff3xYP5yxPog9FgvtWBHQ+1zYnAjddNCo/oA5irLiA8wXqyjrt663P6ZihFWCYxAH8Ya1u6HdjQ0sm0CRynz/9Hn8+ddzKLmO+piNzXWs8Zsoq5oCqmAz0+V3VjxFA/u98MxrbQqlGT6woUfQ4JKJFZ6tUcuES1p2oQhTMUUIldSyX/6MVt6vHBYiAcIuHAtvFyP1DKWpxahFvHUTbJLY9dLPJXFMu70x4nZIQr/zPBhhw3tej8s0s0clDQbypuvo1y1Pt/53u2uaHgXdC9O75CcxixWsyJqjyHI853g30prUJNuUnyBtshsauOf9s9OkFRYNos7IkvNZnp5a9NPJtPnGCQwzXTGsnsAwf2YNV4HhH+i7ttI+CAAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.email.SessionsListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel headerPanel;
    protected com.jurismarches.vradi.entities.Session selectedSession;
    protected javax.swing.JPanel sessionContent;
    protected javax.swing.JTextArea sessionParagraph;
    protected javax.swing.JPanel sessionParagraphPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SessionsListUI $EmailContentUI0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void openUI(VradiTreeNode node) {
    
        Class selectedType = node.getInternalClass();
        if (selectedType.equals(Session.class)) {
            String id = node.getId();
            Session session = VradiService.getWikittyProxy().restore(Session.class, id);
            setSelectedSession(session);
            headerPanel.setVisible(true);
        }
        else {
            // EC20100909 do not display session list at session level
            getHandler().displaySessions(this, getHelper(), node);
        }
    
        revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SessionsListUI() {
        super();
        $initialize();
    }

    public SessionsListUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__sessionParagraph(java.awt.event.FocusEvent event) {
        VradiService.getWikittyProxy().store(getSelectedSession());
    }

    public void doKeyReleased__on__sessionParagraph(java.awt.event.KeyEvent event) {
        getSelectedSession().setParagraph(sessionParagraph.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JPanel getHeaderPanel() {
        return headerPanel;
    }

    public com.jurismarches.vradi.entities.Session getSelectedSession() {
        return selectedSession;
    }

    public javax.swing.JPanel getSessionContent() {
        return sessionContent;
    }

    public javax.swing.JTextArea getSessionParagraph() {
        return sessionParagraph;
    }

    public javax.swing.JPanel getSessionParagraphPanel() {
        return sessionParagraphPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedSession(com.jurismarches.vradi.entities.Session newValue) {
        com.jurismarches.vradi.entities.Session oldValue = this.selectedSession;
        this.selectedSession = newValue;
        firePropertyChange(PROPERTY_SELECTED_SESSION, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToHeaderPanel() {
        if (!allComponentsCreated) {
            return;
        }
        headerPanel.add($Table0, BorderLayout.NORTH);
        headerPanel.add(sessionParagraphPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToSessionParagraphPanel() {
        if (!allComponentsCreated) {
            return;
        }
        sessionParagraphPanel.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createHeaderPanel() {
        $objectMap.put("headerPanel", headerPanel = new javax.swing.JPanel());
        
        headerPanel.setName("headerPanel");
        headerPanel.setLayout(new BorderLayout());
    }

    protected void createSelectedSession() {
        $objectMap.put("selectedSession", selectedSession = null);
    }

    protected void createSessionContent() {
        $objectMap.put("sessionContent", sessionContent = new javax.swing.JPanel());
        
        sessionContent.setName("sessionContent");
        sessionContent.setLayout(new BoxLayout(sessionContent, BoxLayout.Y_AXIS));
    }

    protected void createSessionParagraph() {
        $objectMap.put("sessionParagraph", sessionParagraph = new javax.swing.JTextArea());
        
        sessionParagraph.setName("sessionParagraph");
        sessionParagraph.setColumns(15);
        sessionParagraph.setLineWrap(true);
        sessionParagraph.setWrapStyleWord(true);
        sessionParagraph.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__sessionParagraph"));
        sessionParagraph.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__sessionParagraph"));
    }

    protected void createSessionParagraphPanel() {
        $objectMap.put("sessionParagraphPanel", sessionParagraphPanel = new javax.swing.JPanel());
        
        sessionParagraphPanel.setName("sessionParagraphPanel");
        sessionParagraphPanel.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $EmailContentUI0
        add(headerPanel, BorderLayout.NORTH);
        add($JScrollPane1, BorderLayout.CENTER);
        addChildrenToHeaderPanel();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($HidorButton0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSessionParagraphPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(sessionParagraph);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(sessionContent);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 7 property setters
        $HidorButton0.setHideTip(_("vradi.email.hideSessionParagraph"));
        $HidorButton0.setShowTip(_("vradi.email.showSessionParagraph"));
        $HidorButton0.setTarget(sessionParagraphPanel);
        $HidorButton0.setTargetVisible(false);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$EmailContentUI0", this);
        createSelectedSession();
        createHeaderPanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.email.sessionParagraph"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createSessionParagraphPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSessionParagraph();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createSessionContent();
        // inline creation of $EmailContentUI0
        setName("$EmailContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HEADER_PANEL_VISIBLE, true ,"selectedSession") {
        
            @Override
            public void processDataBinding() {
                headerPanel.setVisible(getSelectedSession() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SESSION_PARAGRAPH_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().addPropertyChangeListener("paragraph", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelectedSession() != null) {
                    jaxx.runtime.SwingUtil.setText(sessionParagraph, getSelectedSession().getParagraph());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selectedSession", this);
                if (getSelectedSession() != null) {
                    getSelectedSession().removePropertyChangeListener("paragraph", this);
                }
            }
        });
    }

}