package com.jurismarches.vradi.ui.admin.loadors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyExtension;

import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;

/**
 * @author letellier
 */
public class FormTypeNodeLoadors extends NavTreeNodeChildLoador<String, WikittyExtension, VradiTreeNode> {

    /** Logger */
    static private final Log log = LogFactory.getLog(FormTypeNodeLoadors.class);
    
    /** serialVersionUID. */
    private static final long serialVersionUID = 6346950208157931299L;

    public FormTypeNodeLoadors() {
        super(WikittyExtension.class);
    }

    public VradiDataService getDataService(NavDataProvider dataProvider) {
        return ((VradiDataProvider) dataProvider).getVradiDataService();
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        VradiDataService dataService = getDataService(dataProvider);
        List<WikittyExtension> formTypes = dataService.getAllFormTypes();
        Collections.sort(formTypes,  VradiComparators.EXTENSION_COMPARATOR);
        return extractIds(formTypes);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {

        return new VradiTreeNode(
                getBeanType(),
                id,
                null,
                null);
    }

    public List<String> extractIds(List<WikittyExtension> entities) {
        List<String> ids = new ArrayList<String>();
        for (WikittyExtension e : entities) {
            ids.add(e.getId());
        }
        return ids;
    }
}