package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.renderers.EntityRenderer;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.text.DateFormat;
import java.util.*;
import java.util.Date;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.nuiton.wikitty.BusinessEntityWikitty;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.SwingUtil.getStringValue;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminGroupUI extends com.jurismarches.vradi.ui.admin.AdminContentUI<Group> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GROUP_NAME_TEXT = "groupName.text";
    public static final String BINDING_REQUEST_LIST_UI_BEAN = "requestListUI.bean";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.AdminGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table adminGroupForm;
    protected com.jurismarches.vradi.entities.Group bean;
    protected javax.swing.JButton createButton;
    protected javax.swing.JTextField groupName;
    protected jaxx.runtime.swing.ListSelectorUI< User > groupUsers;
    protected com.jurismarches.vradi.ui.admin.content.RequestListUI requestListUI;
    protected javax.swing.JLabel title;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminGroupUI $AdminContentUI0 = this;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.HidorButton $HidorButton0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private jaxx.runtime.swing.Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(groupUsers.getCombo(), EntityRenderer.getInstance());
    
        groupUsers.addPropertyChangeListener("modified", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from users");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    }
    
    /**
     * Fill groups and users ListSelectorUI.
     */
    @Override
    protected void postLoadBean() {
    
        createButton.setEnabled(!isInCreation());
    
        if (bean == null) {
            return;
        }
    
        Set<String> users = bean.getUser();
    
        java.util.List<User> toUserList = new java.util.ArrayList<User>();
        if (users!=null){
            for (String user:users){
                User userToAdd = VradiService.getWikittyProxy().restore(User.class, user);
                toUserList.add(userToAdd);
            }
        }
    
        java.util.List<User> toUserCombo = new java.util.ArrayList<User>(getHandler().getAllUsers());
    
        toUserCombo.removeAll(toUserList);
    
        groupUsers.init(toUserCombo, toUserList);
    
        requestListUI.setBean(getBean());
        requestListUI.init();
    }
    
    @Override
    public void save() {
        setModified(false);
    
        EntityHelper.addModificationTagsIfNecessary(bean);
        EntityHelper.setLastModified(bean, new java.util.Date());
        EntityHelper.setLastModifier(bean, getContextValue(VradiUser.class).getLogin());
    
        if(!bean.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG)) {
            BusinessEntityWikitty entityWikitty = (BusinessEntityWikitty) bean;
            entityWikitty.getWikitty().addExtension(ModificationTagImpl.extensionModificationTag);
        }
    
    
        //Use new list to avoid empty queries after clearing
        Group bean = requestListUI.getBean();
        java.util.List<String> queries = null;
        if (bean.getQueries()!=null){
            queries = new java.util.ArrayList<String>(requestListUI.getBean().getQueries());
        }
    
        //Store queries
        bean.clearQueries();
        if (queries!=null){
            for (String query : queries) {
                bean.addQueries(query);
            }
        }
    
        //Store users
        bean.clearUser();
        for (User user : groupUsers.getListDatas()) {
            log.debug("Store user : " + user.getName());
            bean.addUser(user.getWikittyId());
        }
    
        //Set modified to false just before saving to avoid multiple confirmation
        setModified(false);
        Group group = getHandler().saveGroup(bean);
    
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setBean(null);
        setBean(group);
    
        groupUsers.setModified(false);
    }
    
    protected String updateTitle(String name) {
        return _("vradi.adminGroup.title", getStringValue(name));
    }
    
    protected boolean isInCreation() {
        if (bean == null) {
            return false;
        }
        return EntityHelper.getLastModifier(bean) == null;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminGroupUI() {
        super();
        $initialize();
    }

    public AdminGroupUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__createButton(java.awt.event.ActionEvent event) {
        getHandler().createGroup(this, getHelper());setModified(true);
    }

    public void doKeyReleased__on__groupName(java.awt.event.KeyEvent event) {
        getBean().setName(groupName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getAdminGroupForm() {
        return adminGroupForm;
    }

    public com.jurismarches.vradi.entities.Group getBean() {
        return bean;
    }

    public javax.swing.JButton getCreateButton() {
        return createButton;
    }

    public javax.swing.JTextField getGroupName() {
        return groupName;
    }

    public jaxx.runtime.swing.ListSelectorUI< User > getGroupUsers() {
        return groupUsers;
    }

    public com.jurismarches.vradi.ui.admin.content.RequestListUI getRequestListUI() {
        return requestListUI;
    }

    public javax.swing.JLabel getTitle() {
        return title;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.Group newValue) {
        com.jurismarches.vradi.entities.Group oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.HidorButton get$HidorButton0() {
        return $HidorButton0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminGroupForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminGroupForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(SwingUtil.boxComponentWithJxLayer(groupName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminGroupForm.add(groupUsers, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminGroupForm, BorderLayout.NORTH);
        body.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setFieldRepresentation("name", groupName);
    }

    protected void createAdminGroupForm() {
        $objectMap.put("adminGroupForm", adminGroupForm = new jaxx.runtime.swing.Table());
        
        adminGroupForm.setName("adminGroupForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new javax.swing.JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminGroup.createGroup"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createGroupName() {
        $objectMap.put("groupName", groupName = new javax.swing.JTextField());
        
        groupName.setName("groupName");
        groupName.setColumns(15);
        groupName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__groupName"));
    }

    protected void createGroupUsers() {
        $objectMap.put("groupUsers", groupUsers = new jaxx.runtime.swing.ListSelectorUI< User >());
        
        groupUsers.setName("groupUsers");
        groupUsers.setShowHidor(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) groupUsers.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createRequestListUI() {
        $objectMap.put("requestListUI", requestListUI = new com.jurismarches.vradi.ui.admin.content.RequestListUI(this));
        
        requestListUI.setName("requestListUI");
    }

    protected void createTitle() {
        $objectMap.put("title", title = new javax.swing.JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        ((jaxx.runtime.swing.Table) toolbar).setLayout(new BoxLayout(toolbar, 0));
        ((jaxx.runtime.swing.Table) toolbar).putClientProperty("help", "ui.main.toolbar");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.entities.Group >(com.jurismarches.vradi.entities.Group.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        $JPanel0.add($HidorButton0);
        addChildrenToBody();
        addChildrenToAdminGroupForm();
        // inline complete setup of $Table0
        $Table0.add(requestListUI, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        createButton.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.add"));
        createButton.setEnabled(!isInCreation());
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("group.delete"));
        $HidorButton0.setHideTip(_("vradi.adminGroup.hideForm"));
        $HidorButton0.setShowTip(_("vradi.adminGroup.showForm"));
        $HidorButton0.setTarget(adminGroupForm);
        $HidorButton0.setTargetVisible(true);
        groupUsers.setAddToComboTip(_("vradi.adminGroup.removeUser"));
        groupUsers.setAddToListTip(_("vradi.adminGroup.addUser"));
        groupUsers.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        title.setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        // register 1 validator(s)
        validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AdminContentUI0", this);
        createValidator();
        createBean();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminClient.deleteGroup"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $HidorButton0
        $objectMap.put("$HidorButton0", $HidorButton0 = new jaxx.runtime.swing.HidorButton());
        
        $HidorButton0.setName("$HidorButton0");
        createAdminGroupForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminGroup.name"));
        createGroupName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminGroup.listUsers"));
        createGroupUsers();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        createRequestListUI();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(new BoxLayout(toolbar, 0));
        
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GROUP_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(groupName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REQUEST_LIST_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                requestListUI.setBean(getBean());
            }
        });
    }

}