/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.importexport;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyImportExportService;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.importexport.ImportExportMethod;
import org.nuiton.wikitty.importexport.WikittyBatchUpdate;

public class ImportTask
implements Runnable {
    private static Log log = LogFactory.getLog(ImportTask.class);
    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected WikittyImportExportService.FORMAT format;
    protected Reader reader;
    protected ImportExportMethod importerExporter;
    protected String securityToken;

    public ImportTask(String securityToken, WikittyService ws, WikittyImportExportService.FORMAT format, Reader reader) {
        this.securityToken = securityToken;
        this.ws = ws;
        this.format = format;
        this.reader = reader;
        this.transaction = new WikittyTransaction();
    }

    @Override
    public void run() {
        try {
            this.transaction.begin();
            WikittyBatchUpdate batchUpdate = new WikittyBatchUpdate(this.securityToken, this.ws, this.transaction);
            long time = 0L;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info((Object)("Import in (ms)" + time));
            }
            ImportExportMethod importer = this.format.ieporter();
            importer.importReader(this.securityToken, this.reader, this.ws, this.transaction, batchUpdate);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info((Object)("Import in (ms)" + time));
            }
            batchUpdate.flush();
            this.transaction.commit();
        }
        catch (Exception eee) {
            this.transaction.rollback();
            throw new WikittyException(eee);
        }
    }
}

