/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashSet;

public class StreamKeywordTokenizer
extends StreamTokenizer {
    public static final int TT_KEYWORD = -101;
    public static final int TT_VARIABLE = -102;
    protected HashSet<String> keywords = new HashSet();
    protected boolean lowerCaseKeyword = false;
    protected int quoteCharVariable = -1;

    public StreamKeywordTokenizer(Reader in) {
        super(in);
    }

    @Override
    public int nextToken() throws IOException {
        super.nextToken();
        if (this.ttype == -3) {
            String keyword = this.sval;
            if (this.lowerCaseKeyword) {
                keyword = keyword.toLowerCase();
            }
            if (this.keywords.contains(keyword)) {
                this.sval = keyword;
                this.ttype = -101;
            }
        } else if (this.ttype == this.quoteCharVariable) {
            this.ttype = -102;
        }
        return this.ttype;
    }

    public void addKeyword(String keyword) {
        if (this.lowerCaseKeyword) {
            this.keywords.add(keyword.toLowerCase());
        } else {
            this.keywords.add(keyword);
        }
    }

    public void lowerCaseKeyword(boolean fl) {
        this.lowerCaseKeyword = fl;
    }

    public void quoteCharVariable(int c) {
        this.quoteChar(c);
        this.quoteCharVariable = c;
    }
}

