/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static final String DEFAULT_PATTERN = "dd/MM/yyyy";
    public static final String MONTH_PATTERN = "MM/yyyy";

    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date, String pattern, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, locale);
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String date, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date result = simpleDateFormat.parse(date);
        return result;
    }

    public static Date createDate(int s, int m, int h, int dd, int mm, int yy) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, yy);
        calendar.set(2, mm - 1);
        calendar.set(5, dd);
        calendar.set(11, h);
        calendar.set(12, m);
        calendar.set(13, s);
        return calendar.getTime();
    }

    public static Date createDate(int dd, int mm, int yy) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, yy);
        calendar.set(2, mm - 1);
        calendar.set(5, dd);
        return DateUtils.setMinTimeOfDay(calendar.getTime());
    }

    public static Date createDateAfterToday(int ddStep, int mmStep, int yyStep) {
        Calendar calendar = DateUtils.getDefaultCalendar(new Date());
        calendar.add(5, ddStep);
        calendar.add(2, mmStep);
        calendar.add(1, yyStep);
        return calendar.getTime();
    }

    public static Date setLastDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getDefaultCalendar(date);
        int maximum = calendar.getActualMaximum(5);
        calendar.set(5, maximum);
        return calendar.getTime();
    }

    public static Date setFirstDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getDefaultCalendar(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date setMinTimeOfDay(Date date) {
        Calendar calendar = DateUtils.getDefaultCalendar(date);
        calendar.set(9, 0);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setMaxTimeOfDay(Date date) {
        Calendar calendar = DateUtils.getDefaultCalendar(date);
        calendar.set(9, 1);
        calendar.set(10, 11);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean between(Date myDate, Date beforeDate, Date afterDate) {
        if (myDate == null) {
            return false;
        }
        boolean result = true;
        result &= myDate.after(beforeDate) || myDate.compareTo(beforeDate) == 0;
        return result &= afterDate == null || myDate.before(afterDate) || myDate.compareTo(afterDate) == 0;
    }

    public static boolean currentPeriod(Date beforeDate, Date afterDate) {
        return DateUtils.between(new Date(), beforeDate, afterDate);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtils.getDefaultCalendar(date);
        return calendar.get(2);
    }

    public static int getDifferenceInSeconds(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 1000L);
    }

    public static int getDifferenceInMinutes(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 60000L);
    }

    public static int getDifferenceInHours(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 3600000L);
    }

    public static int getDifferenceInDays(Date beginDate, Date endDate) {
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        return (int)Math.ceil((end - begin) / 86400000L);
    }

    public static int getDifferenceInMonths(Date beginDate, Date endDate) {
        int count = 0;
        Calendar fromCalendar = DateUtils.getDefaultCalendar(beginDate);
        Calendar thruCalendar = DateUtils.getDefaultCalendar(endDate);
        while (fromCalendar.before(thruCalendar)) {
            fromCalendar.add(2, 1);
            ++count;
        }
        return count;
    }

    public static String getMonthLibelle(int monthNumber, Locale locale) {
        return new DateFormatSymbols(locale).getMonths()[monthNumber - 1];
    }

    public static String getMonthLibelle(int monthNumber) {
        return DateUtils.getMonthLibelle(monthNumber, Locale.getDefault());
    }

    public static Date getYesterday(Date date) {
        Calendar cal = DateUtils.getDefaultCalendar(date);
        cal.roll(5, false);
        return cal.getTime();
    }

    public static Calendar getDefaultCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

