/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import java.text.SimpleDateFormat;
import org.nuiton.i18n.I18n;

public class VradiConstants {
    public static final String CHANNEL = "channel";
    public static final String ENTRY = "entry";
    public static final String ITEM = "item";
    public static final String USER_ONLY_DECORATOR = "userOnly";
    public static final SimpleDateFormat FORM_ID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String DEFAULT_SENDING_PARAGRAPH = "";
    public static final int DEFAULT_SENDING_STATUS = 0;

    public static enum FileType {
        TEMPLATE,
        EMBEDDED_FORM_FILES,
        ATTACHMENTS_FORM_FILES,
        PDF("application/pdf"),
        WEB_HARVEST,
        QUERY_HISTORY("application/rss+xml"),
        TEMP_FILE;

        private final String mineType;

        private FileType() {
            this("application/octet-stream");
        }

        private FileType(String mineType) {
            this.mineType = mineType;
        }

        public String getMineType() {
            return this.mineType;
        }
    }

    public static enum FormTypeTemplateEnum {
        FIELDS_ELEMENT("fields"),
        FIELD_ELEMENT("field"),
        FIELD_TEMPLATE_ATTRIBUTE("template"),
        FIELD_EXTENSION_ATTRIBUTE("extension");

        private final String value;

        private FormTypeTemplateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum XmlStreamConfig {
        DAYS(I18n.n_((String)"vradi.adminXmlStream.config.interval.days")),
        HOURS(I18n.n_((String)"vradi.adminXmlStream.config.interval.hours")),
        MINUTES(I18n.n_((String)"vradi.adminXmlStream.config.interval.minutes")),
        XML_STREAMS(I18n.n_((String)"vradi.xmlStreams")),
        XML_STREAMS_CONFIG(I18n.n_((String)"vradi.xmlStreams.config")),
        XML_STREAMS_CONFIG_INTERVAL(I18n.n_((String)"vradi.xmlStreams.config.interval")),
        XML_STREAMS_CONFIG_INTERVAL_UNIT(I18n.n_((String)"vradi.xmlStreams.config.interval.unit")),
        XML_STREAMS_CONFIG_INTERVAL_VALUE(I18n.n_((String)"vradi.xmlStreams.config.interval.value")),
        XML_STREAMS_CONFIG_INTERVAL_HOUR(I18n.n_((String)"vradi.xmlStreams.config.interval.hour")),
        XML_STREAMS_CONFIG_INTERVAL_MINUTE(I18n.n_((String)"vradi.xmlStreams.config.interval.minute"));

        private final String value;

        private XmlStreamConfig(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SessionStatus {
        ACTIVE(0, I18n._((String)"vradi.sessionStatus.active")),
        STOPPED(1, I18n._((String)"vradi.sessionStatus.stopped")),
        SENT(2, I18n._((String)"vradi.sessionStatus.sent")),
        CANCELED(3, I18n._((String)"vradi.sessionStatus.canceled")),
        ERROR(4, I18n._((String)"vradi.sessionStatus.error"));

        protected final int value;
        protected final String description;

        private SessionStatus(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static SessionStatus getStatus(int i) {
            SessionStatus result = null;
            for (SessionStatus status : SessionStatus.values()) {
                if (status.getValue() != i) continue;
                result = status;
            }
            return result;
        }
    }

    public static enum SendingStatus {
        DELETED(-1, I18n._((String)"vradi.email.status.deleted")),
        TO_SEND(0, I18n._((String)"vradi.email.status.toSend")),
        SENT(1, I18n._((String)"vradi.email.status.sent")),
        WAITING_RECEPTION_PROOF(2, I18n._((String)"vradi.email.status.waitingReceptionProof")),
        RECEIVED(3, I18n._((String)"vradi.email.status.received")),
        ERROR(4, I18n._((String)"vradi.email.status.error"));

        private final int value;
        private final String description;

        private SendingStatus(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getValue() {
            return this.value;
        }

        public static SendingStatus getStatus(int i) {
            for (SendingStatus status : SendingStatus.values()) {
                if (status.getValue() != i) continue;
                return status;
            }
            return null;
        }
    }

    public static enum FormStatus {
        NON_TRAITE(I18n.n_((String)"vradi.status.nontraite.name"), I18n.n_((String)"vradi.status.nontraite.description"), 0),
        NON_SELECTIONNE(I18n.n_((String)"vradi.status.nonselectionne.name"), I18n.n_((String)"vradi.status.nonselectionne.description"), 1),
        PRESELECTIONNE(I18n.n_((String)"vradi.status.preselectionne.name"), I18n.n_((String)"vradi.status.preselectionne.description"), 2),
        SELECTIONNE(I18n.n_((String)"vradi.status.selectionne.name"), I18n.n_((String)"vradi.status.selectionne.description"), 3);

        private String name;
        private String description;
        private int value;

        private FormStatus(String name, String description, int value) {
            this.name = name;
            this.description = description;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getValue() {
            return this.value;
        }
    }
}

