/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.models;

import com.jurismarches.vradi.beans.ThesaurusCartography;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.ToolTipHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class ThesaurusCartographyModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(ThesaurusCartographyModel.class);
    protected Map<String, List<Thesaurus>> nodeList = new HashMap<String, List<Thesaurus>>();
    protected Map<String, List<Form>> formList = new HashMap<String, List<Form>>();
    protected Map<String, List<Thesaurus>> topLevels = new HashMap<String, List<Thesaurus>>();
    protected Map<String, Integer> cartography;

    public ThesaurusCartographyModel(ThesaurusCartography thesaurusCartography) {
        super((Object)1L);
        this.cartography = thesaurusCartography.getCartography();
        List forms = thesaurusCartography.getForms();
        Set<String> keySet = this.cartography.keySet();
        List<Thesaurus> thesauruss = ThesaurusDataHelper.restoreThesaurus(keySet);
        for (Thesaurus thesaurus : thesauruss) {
            this.nodeList.put(thesaurus.getWikittyId(), new ArrayList());
            this.formList.put(thesaurus.getWikittyId(), new ArrayList());
            this.topLevels.put(thesaurus.getRootThesaurus(), new ArrayList());
        }
        for (Thesaurus thesaurus : thesauruss) {
            String parent = thesaurus.getParent();
            if (this.nodeList.containsKey(parent)) {
                List<Thesaurus> list = this.nodeList.get(parent);
                list.add(thesaurus);
            }
            if (!ThesaurusDataHelper.isFirstChild(thesaurus)) continue;
            String rootThesaurusId = thesaurus.getRootThesaurus();
            List<Thesaurus> thesauruses = this.topLevels.get(rootThesaurusId);
            thesauruses.add(thesaurus);
            this.topLevels.put(rootThesaurusId, thesauruses);
        }
        for (Form form : forms) {
            Set<String> thesaurus = form.getThesaurus();
            if (thesaurus == null || thesaurus.isEmpty()) continue;
            for (String id : thesaurus) {
                if (!this.formList.containsKey(id)) continue;
                List<Form> list = this.formList.get(id);
                list.add(form);
            }
        }
        for (List list : this.nodeList.values()) {
            if (list.isEmpty()) continue;
            Collections.sort(list, VradiComparators.THESAURUS_COMPARATOR);
        }
        for (List list : this.topLevels.values()) {
            Collections.sort(list, VradiComparators.THESAURUS_COMPARATOR);
        }
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(Object node, int column) {
        Object treeNode;
        if (node instanceof RootThesaurus) {
            treeNode = (RootThesaurus)node;
            if (column == 0) {
                return treeNode.getName();
            }
        }
        if (node instanceof Thesaurus) {
            treeNode = (Thesaurus)node;
            if (column == 0) {
                return treeNode;
            }
            if (column == 1) {
                return this.cartography.get(treeNode.getWikittyId());
            }
            if (column == 2) {
                Set tags = (Set)treeNode.getField("Thesaurus", "tags");
                return StringUtils.join((Collection)tags, (char)',');
            }
        }
        return null;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof Long) {
            ArrayList<String> keySet = new ArrayList<String>(this.topLevels.keySet());
            List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.restoreRootThesaurus(keySet);
            Collections.sort(rootThesaurusList, VradiComparators.ROOT_THESAURUS_COMPARATOR);
            return rootThesaurusList.get(index);
        }
        if (parent instanceof RootThesaurus) {
            RootThesaurus treeNode = (RootThesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.topLevels.get(id);
            return list.get(index);
        }
        if (parent instanceof Thesaurus) {
            Thesaurus treeNode = (Thesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.nodeList.get(id);
            return list.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof Long) {
            return this.topLevels.size();
        }
        if (parent instanceof RootThesaurus) {
            RootThesaurus treeNode = (RootThesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.topLevels.get(id);
            return list.size();
        }
        if (parent instanceof Thesaurus) {
            Thesaurus treeNode = (Thesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.nodeList.get(id);
            return list.size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Long) {
            ArrayList<String> keySet = new ArrayList<String>(this.topLevels.keySet());
            List<RootThesaurus> rootThesaurusList = ThesaurusDataHelper.restoreRootThesaurus(keySet);
            Collections.sort(rootThesaurusList, VradiComparators.ROOT_THESAURUS_COMPARATOR);
            return rootThesaurusList.indexOf(child);
        }
        if (parent instanceof RootThesaurus) {
            RootThesaurus treeNode = (RootThesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.topLevels.get(id);
            return list.indexOf(child);
        }
        if (parent instanceof Thesaurus) {
            Thesaurus treeNode = (Thesaurus)parent;
            String id = treeNode.getWikittyId();
            List<Thesaurus> list = this.nodeList.get(id);
            return list.indexOf(child);
        }
        return -1;
    }

    public String getColumnName(int column) {
        String columnName = null;
        if (column == 0) {
            columnName = I18n._((String)"vradi.thesaurus.name");
        } else if (column == 1) {
            columnName = I18n._((String)"vradi.thesaurus.nbforms");
        } else if (column == 2) {
            columnName = I18n._((String)"vradi.thesaurus.tags");
        }
        return columnName;
    }

    public class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object node;
            String toolTip = null;
            if (value instanceof RootThesaurus) {
                node = (RootThesaurus)value;
                value = node.getName();
            }
            if (value instanceof Thesaurus) {
                node = (Thesaurus)value;
                value = node.getName();
                List<Form> forms = ThesaurusCartographyModel.this.formList.get(node.getWikittyId());
                toolTip = ToolTipHelper.getToolTip(forms);
            }
            JComponent component = (JComponent)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            component.setToolTipText(toolTip);
            return component;
        }
    }
}

