/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.loadors;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.BusinessEntity;

public class ThesaurusNodeLoadors
extends NavTreeNodeChildLoador<String, Thesaurus, VradiTreeNode> {
    private static final Log log = LogFactory.getLog(ThesaurusNodeLoadors.class);

    public ThesaurusNodeLoadors() {
        super(Thesaurus.class);
    }

    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        if (RootThesaurus.class.equals(parentClass)) {
            List<Thesaurus> thesauruses = ThesaurusDataHelper.getChildrenOfRootThesaurus(parentId);
            Collections.sort(thesauruses, VradiComparators.THESAURUS_COMPARATOR);
            return this.extractIds(thesauruses);
        }
        List<Thesaurus> childrenOfThesaurus = ThesaurusDataHelper.getChildrenOfThesaurus(parentId);
        Collections.sort(childrenOfThesaurus, VradiComparators.THESAURUS_COMPARATOR);
        return this.extractIds(childrenOfThesaurus);
    }

    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Thesaurus loador] creating thesaurus " + id));
        }
        return new VradiTreeNode(this.getBeanType(), id, null, (NavTreeNodeChildLoador)NavHelper.getChildLoador(ThesaurusNodeLoadors.class));
    }

    public List<String> extractIds(List<? extends BusinessEntity> entities) {
        ArrayList<String> ids = new ArrayList<String>();
        for (BusinessEntity businessEntity : entities) {
            ids.add(businessEntity.getWikittyId());
        }
        return ids;
    }
}

