/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.helpers;

import com.jurismarches.vradi.services.VradiException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlStreamHelper {
    private static final Log log = LogFactory.getLog(XmlStreamHelper.class);

    public static Element getFirstElement(String url) throws VradiException {
        return XmlStreamHelper.getFirstElementXpp(url);
    }

    protected static Element getFirstElementJDom(String url) throws VradiException {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            URL rssUrl = new URL(url);
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(rssUrl);
            Element racine = document.getRootElement();
            log.debug((Object)("Root element name: " + racine.getName()));
            Element firstElement = null;
            if (racine.getChild("item") != null) {
                firstElement = racine.getChild("item");
            } else if (racine.getChild("entry") != null) {
                firstElement = racine.getChild("entry");
            } else if (racine.getChild("channel") != null) {
                Element element = racine.getChild("channel");
                firstElement = element.getChild("item");
            }
            log.debug((Object)(System.currentTimeMillis() - currentTimeMillis));
            return firstElement;
        }
        catch (Exception eee) {
            log.error((Object)eee.getMessage(), (Throwable)eee);
            throw new VradiException("Cant get first element", (Throwable)eee);
        }
    }

    protected static Element getFirstElementXpp(String url) throws VradiException {
        Element element;
        InputStream openStream = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            URL rssUrl = new URL(url);
            openStream = rssUrl.openStream();
            InputStreamReader streamReader = new InputStreamReader(openStream);
            BufferedReader bufferedReader = new BufferedReader(streamReader);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.supportDTD", "false");
            XMLStreamReader reader = inputFactory.createXMLStreamReader(bufferedReader);
            Element firstElement = null;
            while (reader.hasNext()) {
                String localName;
                int type = reader.next();
                if (type == 1) {
                    localName = reader.getLocalName();
                    if (firstElement == null && (localName.equals("item") || localName.equals("entry"))) {
                        firstElement = new Element(localName);
                        continue;
                    }
                    if (firstElement == null) continue;
                    Element element2 = new Element(localName);
                    firstElement.addContent((Content)element2);
                    continue;
                }
                if (type == 4 || type == 12) {
                    if (firstElement == null || firstElement.getContentSize() <= 0) continue;
                    int contentSize = firstElement.getContentSize();
                    Element content = (Element)firstElement.getContent(contentSize - 1);
                    content.setText(content.getTextTrim() + reader.getText());
                    continue;
                }
                if (type != 2) continue;
                localName = reader.getLocalName();
                if (firstElement == null || !localName.equals("item") && !localName.equals("entry")) continue;
                break;
            }
            log.debug((Object)(System.currentTimeMillis() - currentTimeMillis));
            element = firstElement;
        }
        catch (Exception eee) {
            try {
                log.error((Object)eee.getMessage(), (Throwable)eee);
                throw new VradiException("Cant get first element", (Throwable)eee);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(openStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)openStream);
        return element;
    }

    public static Set<String> getRSSFields(Element firstElement) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRSSFields");
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (firstElement != null) {
            for (Element elt : firstElement.getChildren()) {
                result.add(elt.getName());
            }
        }
        return result;
    }

    public static Map<String, String> getFirstElementValues(Element firstElement) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (firstElement != null) {
            for (Element elt : firstElement.getChildren()) {
                result.put(elt.getName(), elt.getText());
            }
        }
        return result;
    }
}

