/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;
import com.jurismarches.vradi.ui.admin.loadors.ClientUsersNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public abstract class AdminNavigationTreeHelper
extends NavTreeHelper<VradiTreeNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(AdminNavigationTreeHelper.class);

    public AdminNavigationTreeHelper(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root = new VradiTreeNode(String.class, "Root node", null, null);
        VradiTreeNode child = this.createNode();
        root.add(child);
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        return model;
    }

    public abstract VradiTreeNode createNode();

    public VradiTreeNode getParentSelectedCategoryNode(String categoryName) {
        return AdminNavigationTreeHelper.getParentCategoryNode((VradiTreeNode)this.getSelectedNode(), categoryName);
    }

    public static VradiTreeNode getParentCategoryNode(VradiTreeNode node, String categoryName) {
        if (node == null) {
            return null;
        }
        if (categoryName.equals(node.getId())) {
            return node;
        }
        return AdminNavigationTreeHelper.getParentCategoryNode((VradiTreeNode)node.getParent(), categoryName);
    }

    public VradiTreeNode getParentSelectedNode(Class type) {
        return AdminNavigationTreeHelper.getParentNode((VradiTreeNode)this.getSelectedNode(), type);
    }

    public static VradiTreeNode getParentNode(VradiTreeNode node, Class type) {
        if (node == null) {
            return null;
        }
        if (type.equals(node.getInternalClass())) {
            return node;
        }
        return AdminNavigationTreeHelper.getParentNode((VradiTreeNode)node.getParent(), type);
    }

    public void refresh(VradiTreeNode parentNode) {
        if (parentNode == null) {
            return;
        }
        parentNode.removeAllChildren();
        parentNode.populateChilds(this.getBridge(), this.getDataProvider());
        ((NavTreeBridge)this.getBridge()).nodeStructureChanged((TreeNode)((Object)parentNode));
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass, String categoryName) {
        this.createNode(nodeLoadorsClass, categoryName, null);
    }

    public void createNode(Class<? extends NavTreeNodeChildLoador<String, ?, VradiTreeNode>> nodeLoadorsClass, String categoryName, String id) {
        VradiTreeNode parentNode = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{categoryName});
        VradiTreeNode node = (VradiTreeNode)((NavTreeNodeChildLoador)AdminNavigationTreeHelper.getChildLoador(nodeLoadorsClass)).createNode((Object)id, (NavDataProvider)this.getDataProvider());
        this.insertNodeAndSelect(parentNode, node);
    }

    public void createUserNode(VradiTreeNode clientNode) {
        VradiTreeNode parentNode = (VradiTreeNode)this.findNode((NavNode)clientNode, new String[]{AdminBeanConstant.USER.getCategoryName()});
        VradiTreeNode node = ((ClientUsersNodeLoadors)AdminNavigationTreeHelper.getChildLoador(ClientUsersNodeLoadors.class)).createNode(null, (NavDataProvider)this.getDataProvider());
        this.insertNodeAndSelect(parentNode, node);
    }

    protected void insertNodeAndSelect(VradiTreeNode parentNode, VradiTreeNode node) {
        parentNode.add(node);
        ((NavTreeBridge)this.getBridge()).notifyNodeInserted((NavTreeNode)node);
        TreePath path = new TreePath(((NavTreeBridge)this.getBridge()).getPathToRoot((TreeNode)((Object)node)));
        ((JTree)this.getUI()).expandPath(path);
        this.selectNode((NavNode)node);
    }

    public void reSelectCategory(VradiTreeNode node) {
        String id = ((VradiTreeNode)node.getParent()).getId();
        log.debug((Object)("Try to load subcategory for node : " + id));
        this.selectNode(new String[]{id, node.getId()});
    }

    public void putWikitty(WikittyServiceEvent event) {
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            VradiTreeNode node = (VradiTreeNode)this.findNode(this.getRootNode(), new String[]{wikittyId});
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)node));
            node.removeFromParent();
            ((NavTreeBridge)this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeNode[]{node});
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

