/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI;
import com.jurismarches.vradi.ui.admin.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusConfirmDialogUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusEditUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusPathChooserUI;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusQueryChangesHandler;
import com.jurismarches.vradi.ui.admin.popups.ThesaurusQueryChangesUI;
import com.jurismarches.vradi.ui.admin.query.ThesaurusChangesTreeTableModel;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusCartographyUI;
import com.jurismarches.vradi.ui.renderers.ColorsMap;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.nav.NavHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class AdminThesaurusHandler {
    private static Log log = LogFactory.getLog(AdminThesaurusHandler.class);
    private VradiStorageService vradiStorageService = null;

    public WikittyProxy getProxy() {
        return VradiService.getWikittyProxy();
    }

    protected AdminThesaurusUI getUI(JAXXContext context) {
        return (AdminThesaurusUI)context;
    }

    public Thesaurus getThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(Thesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getThesaurus(id);
    }

    public Thesaurus getThesaurus(String id) {
        return ThesaurusDataHelper.restoreThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(VradiTreeTableNode parentNode) {
        Class type = parentNode.getInternalClass();
        if (!type.equals(RootThesaurus.class)) {
            return null;
        }
        String id = parentNode.getId();
        return this.getRootThesaurus(id);
    }

    public RootThesaurus getRootThesaurus(String id) {
        return ThesaurusDataHelper.restoreRootThesaurus(id);
    }

    protected VradiTreeTableNode getSelectedNode(ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
        if (selectedNode == null) {
            selectedNode = (VradiTreeTableNode)helper.getRootNode();
        }
        return selectedNode;
    }

    public void createRootThesaurus(JAXXContext context) {
        int n;
        String name = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), (Object)I18n._((String)"vradi.adminThesaurus.askRootThesaurusName"));
        if (name != null && (n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askCreateRootThesaurus", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.saveTitle"), 2)) == 0) {
            if (ThesaurusDataHelper.checkRootNameExist(name)) {
                int n2 = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n2 == 0) {
                    this.createRootThesaurus(context);
                }
                return;
            }
            RootThesaurusImpl newRootThesaurus = new RootThesaurusImpl();
            newRootThesaurus.setName(name);
            this.getProxy().store((BusinessEntity)newRootThesaurus);
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, newRootThesaurus.getWikittyId());
        }
    }

    public void createThesaurus(JAXXContext context, RootThesaurus parentRootThesaurus) {
        String name;
        ThesaurusImpl thesaurusToCreate = new ThesaurusImpl();
        String rootId = parentRootThesaurus.getWikittyId();
        thesaurusToCreate.setParent(rootId);
        thesaurusToCreate.setRootThesaurus(rootId);
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle"), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus root = ThesaurusDataHelper.restoreRootThesaurus(rootId);
            if (ThesaurusDataHelper.checkNameExist(root, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentRootThesaurus);
                }
                return;
            }
            this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentRootThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurusToCreate.getWikittyId());
        }
    }

    public void createThesaurus(JAXXContext context, Thesaurus parentThesaurus) {
        String name;
        ThesaurusImpl thesaurusToCreate = new ThesaurusImpl();
        thesaurusToCreate.setParent(parentThesaurus.getWikittyId());
        thesaurusToCreate.setRootThesaurus(parentThesaurus.getRootThesaurus());
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        edit.init(thesaurusToCreate, I18n._((String)"vradi.adminThesaurus.creationTitle"), true);
        if (edit.isSave().booleanValue() && (name = thesaurusToCreate.getName()) != null && !name.isEmpty()) {
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurusToCreate.getRootThesaurus());
            if (ThesaurusDataHelper.checkNameExist(rootThesaurus, name)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.createThesaurus(context, parentThesaurus);
                }
                return;
            }
            this.getProxy().store((BusinessEntity)thesaurusToCreate);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding thesaurus " + thesaurusToCreate.getName() + " to parent " + parentThesaurus.getName()));
            }
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurusToCreate.getWikittyId());
        }
    }

    public void editRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        String oldName = rootThesaurus.getName();
        String name = JOptionPane.showInputDialog((Component)((Object)this.getUI(context)), (Object)I18n._((String)"vradi.adminThesaurus.askRootThesaurusEditName", (Object[])new Object[]{oldName}));
        if (name != null && !name.isEmpty()) {
            if (ThesaurusDataHelper.checkRootNameExist(rootThesaurus)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{name}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.editRootThesaurus(context, rootThesaurus);
                }
                return;
            }
            int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askEditRootThesaurus", (Object[])new Object[]{oldName, name}), I18n._((String)"vradi.admin.saveTitle"), 2);
            if (n == 0) {
                this.modifyQueries(context, oldName, name, null, null);
                rootThesaurus.setName(name);
                this.getProxy().store((BusinessEntity)rootThesaurus);
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                UIHelper.selectNodeLater((NavHelper)helper, rootThesaurus.getWikittyId());
            }
        }
    }

    public void editThesaurus(JAXXContext context, Thesaurus thesaurus) {
        ThesaurusEditUI edit = new ThesaurusEditUI(context);
        String oldName = thesaurus.getName();
        edit.init(thesaurus, I18n._((String)"vradi.adminThesaurus.editTitle", (Object[])new Object[]{oldName}), false);
        if (edit.isSave().booleanValue() && oldName != null && !oldName.isEmpty()) {
            String rootId = thesaurus.getRootThesaurus();
            RootThesaurus rootThesaurus = this.getRootThesaurus(rootId);
            if (ThesaurusDataHelper.checkNameExist(rootThesaurus, thesaurus)) {
                int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.warnNameIsExisting", (Object[])new Object[]{oldName}), I18n._((String)"vradi.admin.warnTitle"), 2);
                if (n == 0) {
                    this.editThesaurus(context, thesaurus);
                }
                return;
            }
            String newName = thesaurus.getName();
            boolean responce = true;
            if (!oldName.equals(newName)) {
                thesaurus.setName(oldName);
                responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askEditThesaurus", (Object[])new Object[]{oldName, ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.saveTitle"));
            }
            if (responce) {
                thesaurus.setName(newName);
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), oldName, thesaurus.getName());
                this.getProxy().store((BusinessEntity)thesaurus);
                ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
                UIHelper.selectNodeLater((NavHelper)helper, thesaurus.getWikittyId());
            }
        }
    }

    public void moveThesaurus(JAXXContext context, Thesaurus thesaurus) {
        VradiTreeTableNode selectedNode;
        String id;
        boolean responce;
        String rootThesaurusId = thesaurus.getRootThesaurus();
        RootThesaurus rootThesaurus = this.getRootThesaurus(rootThesaurusId);
        ThesaurusTreeTableHelper selectHelper = new ThesaurusTreeTableHelper(rootThesaurus);
        ThesaurusPathChooserUI selectUI = new ThesaurusPathChooserUI(context, selectHelper);
        selectUI.setVisible(true);
        if (selectUI.isSaved().booleanValue() && (responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askMoveThesaurus", (Object[])new Object[]{thesaurus.getName()}), I18n._((String)"vradi.adminThesaurus.moveTitle"))) && !(id = (selectedNode = this.getSelectedNode(selectHelper)).getId()).equals(thesaurus.getParent())) {
            thesaurus.setParent(id);
            this.getProxy().store((BusinessEntity)thesaurus);
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, thesaurus.getWikittyId());
        }
    }

    public void deleteRootThesaurus(JAXXContext context, RootThesaurus rootThesaurus) {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this.getUI(context)), I18n._((String)"vradi.adminThesaurus.askDeleteRootThesaurus", (Object[])new Object[]{rootThesaurus.getName()}), I18n._((String)"vradi.admin.deleteTitle"), 2);
        if (n == 0) {
            List<String> childrenList = ThesaurusDataHelper.getChildrenRecursif(rootThesaurus);
            this.getProxy().delete(childrenList);
            this.getProxy().delete(rootThesaurus.getWikittyId());
        }
    }

    public boolean deleteThesaurus(JAXXContext context, Thesaurus thesaurus) {
        boolean responce = this.showThesaurusConfirmDialog(context, thesaurus, I18n._((String)"vradi.adminThesaurus.askDeleteThesaurus", (Object[])new Object[]{thesaurus.getName(), ThesaurusDataHelper.getNbFormsForThesaurus(thesaurus)}), I18n._((String)"vradi.admin.deleteTitle"));
        if (responce) {
            String parentId = thesaurus.getParent();
            List<String> childrenList = ThesaurusDataHelper.getChildrenRecursif(thesaurus);
            RootThesaurus rootThesaurus = ThesaurusDataHelper.restoreRootThesaurus(thesaurus.getRootThesaurus());
            this.modifyDeleteRequest(context, rootThesaurus, thesaurus, childrenList);
            this.getProxy().delete(childrenList);
            ThesaurusTreeTableHelper helper = (ThesaurusTreeTableHelper)((Object)context.getContextValue(ThesaurusTreeTableHelper.class));
            UIHelper.selectNodeLater((NavHelper)helper, parentId);
            return true;
        }
        return false;
    }

    protected void modifyDeleteRequest(JAXXContext context, RootThesaurus rootThesaurus, Thesaurus thesaurus, List<String> childrenList) {
        for (String childId : childrenList) {
            Thesaurus child = ThesaurusDataHelper.restoreThesaurus(childId);
            if (ThesaurusDataHelper.isFirstChild(child)) {
                this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), null);
                return;
            }
            Thesaurus parent = null;
            String parentId = thesaurus.getParent();
            while (childrenList.contains(parentId)) {
                parent = ThesaurusDataHelper.restoreThesaurus(parentId);
                if (ThesaurusDataHelper.isFirstChild(parent)) {
                    this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), null);
                    return;
                }
                parentId = parent.getParent();
            }
            this.modifyQueries(context, rootThesaurus.getName(), rootThesaurus.getName(), child.getName(), parent == null ? null : parent.getName());
        }
    }

    public void addChildThesaurusToSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.createThesaurus(context, rootThesaurus);
            return;
        }
        this.createThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void editThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.editRootThesaurus(context, rootThesaurus);
            return;
        }
        this.editThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void deleteThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        RootThesaurus rootThesaurus = this.getRootThesaurus(selectedNode);
        if (rootThesaurus != null) {
            this.deleteRootThesaurus(context, rootThesaurus);
            return;
        }
        this.deleteThesaurus(context, this.getThesaurus(selectedNode));
    }

    public void moveThesaurusSelected(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus thesaurus = this.getThesaurus(selectedNode);
        this.moveThesaurus(context, thesaurus);
    }

    public boolean showThesaurusConfirmDialog(JAXXContext context, Thesaurus concerned, String title, String msg) {
        ThesaurusConfirmDialogUI condirmDialogUI = new ThesaurusConfirmDialogUI(context);
        condirmDialogUI.init(concerned, title, msg);
        return condirmDialogUI.isSave();
    }

    public void showApply(JAXXContext context, Thesaurus concerned) {
        UIHelper.getHandler(context, AdminHandler.class).openRequest(context, concerned);
    }

    protected void modifyQueries(JAXXContext context, String rootThesaurusBefore, String rootThesaurusAfter, String thesaurusBefore, String thesaurusAfter) {
        Map queryMakers = VradiService.getVradiStorageService().getQueriesToModifyAfterThesaurusModification(rootThesaurusBefore, thesaurusBefore);
        if (queryMakers.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[ModifyQueries] Query makers are empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[ModifyQueries] Query makers are not empty for thesaurus : " + rootThesaurusBefore + ":" + thesaurusBefore + " will show modification UI"));
        }
        ThesaurusQueryChangesHandler handler = new ThesaurusQueryChangesHandler();
        ThesaurusQueryChangesUI thesaurusChangesUI = handler.initUI(context, queryMakers, rootThesaurusBefore, rootThesaurusAfter, thesaurusBefore, thesaurusAfter);
        thesaurusChangesUI.setModifiedQueries(Boolean.FALSE);
        thesaurusChangesUI.setVisible(true);
        if (!thesaurusChangesUI.isModifiedQueries().booleanValue()) {
            return;
        }
        try {
            ThesaurusChangesTreeTableModel model = thesaurusChangesUI.getContextValue(ThesaurusChangesTreeTableModel.class);
            List<QueryMaker> updatedQueryMakers = model.getUpdatedQueryMakers();
            VradiService.getWikittyProxy().store(updatedQueryMakers);
            if (log.isDebugEnabled()) {
                log.debug((Object)"[ModifyQueries] Store modifications");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void changeThesaurusColor(JAXXContext context, ThesaurusTreeTableHelper helper) {
        VradiTreeTableNode selectedNode = this.getSelectedNode(helper);
        Thesaurus selected = this.getThesaurus(selectedNode);
        int depth = ThesaurusDataHelper.getDepth(selected);
        Color initialColor = ColorsMap.getInstance().get(depth);
        Color colorChoosed = JColorChooser.showDialog((Component)((Object)((AdminThesaurusUI)context)), I18n._((String)"vradi.thesaurus.colorTitle"), initialColor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Store color " + colorChoosed + " for depth " + depth));
        }
        VradiHelper.storeThesaurusColor(depth, colorChoosed);
        this.reinitColors();
    }

    public void reinitColors() {
        ColorsMap.getInstance().updateColors();
    }

    public void exportThesaurusCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.exportThesaurusTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.exportButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporting thesaurus to : " + selectedFile.getAbsolutePath()));
                    }
                    Search search = Search.query().eq(Element.ELT_EXTENSION, "TreeNode");
                    Criteria criteria = search.criteria();
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String vscContent = vradiStorageService.exportAsCSV(criteria);
                    FileUtils.writeStringToFile((File)selectedFile, (String)vscContent);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export thesaurus", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't export thesaurus", (Throwable)eee);
            }
        }
    }

    protected VradiStorageService getVradiStorageService() {
        if (this.vradiStorageService == null) {
            this.vradiStorageService = VradiService.getVradiStorageService();
        }
        return this.vradiStorageService;
    }

    public void importCSV(AdminThesaurusUI adminThesaurusUI) {
        block6: {
            try {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(I18n._((String)"vradi.adminThesaurus.importTitle"));
                chooser.setApproveButtonText(I18n._((String)"vradi.adminThesaurus.importButtonText"));
                int returnVal = chooser.showOpenDialog((Component)((Object)adminThesaurusUI));
                if (returnVal == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Importing file : " + selectedFile.getAbsolutePath()));
                    }
                    VradiStorageService vradiStorageService = this.getVradiStorageService();
                    String uri = selectedFile.toURI().toURL().toExternalForm();
                    vradiStorageService.importAsCSV(uri);
                }
            }
            catch (VradiException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import file", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)((Object)eee));
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Can't import file", (Throwable)eee);
            }
        }
    }

    public static class CopyToClipboard
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected AdminThesaurusUI thesaurusUI;
        protected ThesaurusCartographyUI thesaurusCartography;

        public CopyToClipboard(AdminThesaurusUI thesaurusUI) {
            super(I18n._((String)"vradi.common.copy"));
            this.thesaurusUI = thesaurusUI;
            JXTreeTable treeTable = thesaurusUI.getThesaurus();
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        public CopyToClipboard(ThesaurusCartographyUI thesaurusCartography) {
            super(I18n._((String)"vradi.common.copy"));
            this.thesaurusCartography = thesaurusCartography;
            JXTreeTable treeTable = thesaurusCartography.getCartographyTable();
            InputMap inputMap = treeTable.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(67, 2), "ThesaurusHandler.CopyToClipboard");
            ActionMap actionMap = treeTable.getActionMap();
            actionMap.put("ThesaurusHandler.CopyToClipboard", this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String id = null;
            if (this.thesaurusUI != null) {
                ThesaurusTreeTableHelper helper = this.thesaurusUI.helper;
                VradiTreeTableNode selectedNode = (VradiTreeTableNode)helper.getSelectedNode();
                if (selectedNode == null || selectedNode.isRoot()) {
                    return;
                }
                id = selectedNode.getId();
            } else {
                TreePath[] selectedPaths = this.thesaurusCartography.getCartographyTable().getTreeSelectionModel().getSelectionPaths();
                log.info(e.getSource());
            }
            Thesaurus bean = ThesaurusDataHelper.restoreThesaurus(id);
            if (bean == null) {
                return;
            }
            String name = "\"" + bean.getName() + "\"";
            StringSelection selection = new StringSelection("thesaurus:" + name);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
        }
    }
}

