/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.TreeNode;

public class Thesaurus {
    private static final Log log = LogFactory.getLog(Thesaurus.class);
    protected boolean toSave = false;
    protected boolean toDelete = false;
    protected TreeNode bean;
    protected String name;
    protected String wikittyId;
    protected TreeNode parent;
    protected Map<String, Thesaurus> children = new HashMap<String, Thesaurus>();

    public Thesaurus(TreeNode bean) {
        this.setBean(bean);
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
        if (this.children != null) {
            for (Thesaurus child : this.getChildren()) {
                child.setToDelete(toDelete);
            }
        }
    }

    public boolean isToSave() {
        return this.toSave;
    }

    public void setToSave(boolean toSave) {
        this.toSave = toSave;
    }

    public TreeNode getBean() {
        this.bean.setName(this.getName());
        this.bean.clearChildren();
        for (Thesaurus child : this.getChildren()) {
            this.bean.addChildren(child.getWikittyId());
        }
        if (this.parent != null) {
            this.bean.setParent(this.parent.getWikittyId());
        }
        return this.bean;
    }

    public void setBean(TreeNode bean) {
        this.bean = bean;
        this.setName(bean.getName());
        this.setWikittyId(bean.getWikittyId());
        VradiStorageService service = ServiceHelper.getVradiStorageService();
        try {
            TreeNode treeNodeParent;
            String parent;
            if (bean.getChildren() != null) {
                for (String thesaurusId : bean.getChildren()) {
                    TreeNode treeNodeChild = service.getThesaurus(thesaurusId);
                    if (treeNodeChild == null) continue;
                    this.addChild(new Thesaurus(treeNodeChild));
                }
            }
            if ((parent = bean.getParent()) != null && (treeNodeParent = service.getThesaurus(parent)) != null) {
                this.setParent(treeNodeParent);
            }
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant find thesaurus ", (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public Collection<Thesaurus> getChildren() {
        return this.children.values();
    }

    public void addChild(Thesaurus element) {
        this.bean.addChildren(element.getWikittyId());
        this.children.put(element.getWikittyId(), element);
    }

    public void clearChildren() {
        this.bean.clearChildren();
        this.children.clear();
    }

    public void removeChild(Thesaurus child) {
        this.bean.removeChildren(child.getWikittyId());
        this.children.remove(child);
    }

    public boolean addChildRecursif(Thesaurus child) {
        TreeNode p = child.getParent();
        if (this.bean.equals(p)) {
            this.children.put(child.getWikittyId(), child);
            return true;
        }
        Iterator<Thesaurus> i$ = this.children.values().iterator();
        if (i$.hasNext()) {
            Thesaurus c = i$.next();
            return c.addChildRecursif(child);
        }
        return false;
    }

    public Thesaurus removeThesaurusRecursivly(String id) {
        Thesaurus thesaurus = this.children.get(id);
        if (thesaurus != null) {
            return this.children.remove(id);
        }
        Iterator<Thesaurus> i$ = this.children.values().iterator();
        if (i$.hasNext()) {
            Thesaurus c = i$.next();
            return c.removeThesaurusRecursivly(id);
        }
        return null;
    }

    public Thesaurus findThesaurus(String id) {
        Thesaurus thesaurus = this.children.get(id);
        if (thesaurus != null) {
            return thesaurus;
        }
        Iterator<Thesaurus> i$ = this.children.values().iterator();
        if (i$.hasNext()) {
            Thesaurus c = i$.next();
            return c.findThesaurus(id);
        }
        return null;
    }

    public String getRecursifName() {
        return this.getRecursifName(this.getName());
    }

    protected String getRecursifName(String name) {
        Collection<Thesaurus> children = this.getChildren();
        if (children != null) {
            for (Thesaurus child : children) {
                name = name + ", " + child.getRecursifName();
            }
        }
        return name;
    }
}

