package org.sharengo.wikitty;

import org.sharengo.wikitty.FieldType.TYPE;

public class FieldFactory {
	
	private ExtensionFactory parentFactory;
	private String fieldName; 
	private TYPE type;
	private int minOccur = 0, maxOccur = 1; 
	private boolean unique = false;
	
	public FieldFactory(ExtensionFactory parentFactory, String fieldName, TYPE type) {
		this.parentFactory = parentFactory;
		this.fieldName = fieldName;
		this.type = type;
	}
	
	public FieldFactory addField( String name, TYPE type ) {
		append();
		return parentFactory.addField(name, type);
	}
	
	public WikittyExtension extension() {
		append();
		return parentFactory.extension();
	}
	
	private void append() {
		FieldType fieldType = new FieldType( type, minOccur, maxOccur, unique, minOccur > 0 ); 
		parentFactory.add( fieldName, fieldType );
	}
	
	public FieldFactory maxOccur(int max) {
		maxOccur = max;
		return this;
	}
	
	public FieldFactory minOccur(int min) {
		minOccur = min;
		return this;
	}
	
	public FieldFactory unique() {
		unique = true;
		return this;
	}

}
