package org.sharengo.wikitty;

import java.util.LinkedHashMap;

import org.sharengo.wikitty.FieldType.TYPE;

public class ExtensionFactory {
	
	private String name;
	private String version;
	private String requiredExtension;

	private LinkedHashMap<String, FieldType> fields;
	
	private ExtensionFactory(String name, String version) {
		this.name = name;
		this.version = version;
		this.fields = new LinkedHashMap<String, FieldType>();
	}
	
	public static ExtensionFactory create(String name, String version) {
		return new ExtensionFactory(name, version);
	}
	
	public FieldFactory addField(String name, TYPE fieldType) {
		return new FieldFactory(this, name, fieldType);
	}
	
	public WikittyExtension extension() {
		WikittyExtension ext = new WikittyExtension( name, version, requiredExtension, fields );
		return ext;
	}
	
	protected void add(String fieldName, FieldType fieldType) {
		fields.put(fieldName, fieldType);
	}

}
