/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiAction;
import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.ui.Thesaurus;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.DecoratorProvider;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.StringUtil;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class VradiMain {
    private static Log log = LogFactory.getLog(VradiMain.class);

    public static void main(String[] args) {
        long startingTime = System.nanoTime();
        log.info((Object)("Vradi start at " + new Date() + " args: " + Arrays.toString(args)));
        Logger.getLogger("org.apache.solr").setLevel(Level.FINEST);
        try {
            VradiContext context = VradiMain.init(args);
            log.info((Object)I18n._((String)"vradi.init.context.done", (Object[])new Object[]{StringUtil.convertTime((long)startingTime, (long)System.nanoTime())}));
            Util.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)Util.newContextEntryDef(VradiConfig.class));
            Util.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)Util.newContextEntryDef(VradiAction.class));
            VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
            config.doAction(VradiConfig.Step.AfterInit.ordinal());
            if (config.isDisplayMainUI()) {
                VradiMainUIHandler uiHandler = (VradiMainUIHandler)context.getContextValue(VradiMainUIHandler.class);
                final VradiMainUI ui = uiHandler.initUI((JAXXContext)context, config.isFullScreen());
                log.info((Object)I18n._((String)"vradi.init.ui.done"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.setVisible(true);
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
            System.exit(1);
        }
    }

    public static VradiContext init(String ... args) throws Exception {
        System.setSecurityManager(null);
        long t0 = System.nanoTime();
        I18n.setUniqueBundleName((String)"vradi-swing-i18n");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        VradiContext context = VradiContext.init();
        DecoratorProvider p = new DecoratorProvider(){

            protected void loadDecorators() {
                this.registerMultiJXPathDecorator(Client.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(User.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Group.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(WikittyExtension.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(XmlStream.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(Thesaurus.class, "${name}$s", "", "");
                this.registerMultiJXPathDecorator(TreeNode.class, "${name}$s", "", "");
            }
        };
        context.setContextValue(p);
        context.setContextValue(new DecoratorProviderListCellRenderer(p));
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        config.parse(args);
        long t00 = System.nanoTime();
        I18n.init((Locale)config.getLocale());
        log.info((Object)("language : " + config.getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        log.info((Object)I18n._((String)"vradi.message.config.loaded", (Object[])new Object[]{config.getVersion()}));
        try {
            SwingUtil.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"vradi.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"vradi.warning.no.ui"));
            config.setCanUseUI(false);
        }
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        if (config.isCanUseUI()) {
            SwingUtil.loadUIConfig((String)"/vradi.properties", null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown vradi");
        }

        @Override
        public void run() {
            try {
                super.run();
                VradiContext.get().close();
                log.info((Object)I18n._((String)"vradi.init.closed", (Object[])new Object[]{new Date()}));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

