/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.util.NumberUtils;

class SortableFloatFieldSource
extends FieldCacheSource {
    protected float defVal;
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public SortableFloatFieldSource(String field) {
        this(field, 0.0f);
    }

    public SortableFloatFieldSource(String field, float defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "sfloat(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        FieldCache.StringIndex index = this.cache.getStringIndex(reader, this.field);
        final int[] order = index.order;
        final String[] lookup = index.lookup;
        final float def = this.defVal;
        return new DocValues(){

            public float floatVal(int doc) {
                int ord = order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2float(lookup[ord]);
            }

            public int intVal(int doc) {
                return (int)this.floatVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.floatVal(doc);
            }

            public double doubleVal(int doc) {
                return this.floatVal(doc);
            }

            public String strVal(int doc) {
                return Float.toString(this.floatVal(doc));
            }

            public String toString(int doc) {
                return SortableFloatFieldSource.this.description() + '=' + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableFloatFieldSource && super.equals(o) && this.defVal == ((SortableFloatFieldSource)o).defVal;
    }

    public int hashCode() {
        return hcode + super.hashCode() + Float.floatToIntBits(this.defVal);
    }
}

