/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;

public class DumpRequestHandler
extends RequestHandlerBase {
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.add("params", req.getParams().toNamedList());
        if (req.getContentStreams() != null) {
            ArrayList<SimpleOrderedMap> streams = new ArrayList<SimpleOrderedMap>();
            for (ContentStream content : req.getContentStreams()) {
                SimpleOrderedMap stream = new SimpleOrderedMap();
                stream.add("name", (Object)content.getName());
                stream.add("fieldName", (Object)content.getSourceInfo());
                stream.add("size", (Object)content.getSize());
                stream.add("contentType", (Object)content.getContentType());
                stream.add("stream", (Object)IOUtils.toString((InputStream)content.getStream()));
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    public String getDescription() {
        return "Dump handler (debug)";
    }

    public String getVersion() {
        return "$Revision: 547101 $";
    }

    public String getSourceId() {
        return "$Id: DumpRequestHandler.java 547101 2007-06-14 03:26:18Z ryan $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/DumpRequestHandler.java $";
    }
}

