/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageListMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableMouseListener;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SwingValidatorUtil
extends BeanValidatorUtil {
    static ImageIcon errorIcon;
    static ImageIcon warningIcon;
    static ImageIcon infoIcon;
    private static final Log log;

    public static ImageIcon getErrorIcon() {
        if (errorIcon == null) {
            errorIcon = Util.createImageIcon("error.png");
        }
        return errorIcon;
    }

    public static ImageIcon getInfoIcon() {
        if (infoIcon == null) {
            infoIcon = Util.createImageIcon("info.png");
        }
        return infoIcon;
    }

    public static ImageIcon getWarningIcon() {
        if (warningIcon == null) {
            warningIcon = Util.createImageIcon("warning.png");
        }
        return warningIcon;
    }

    protected SwingValidatorUtil() {
    }

    public static void installUI(JTable errorTable, SwingValidatorMessageTableRenderer render) {
        errorTable.setDefaultRenderer(Object.class, render);
        errorTable.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        SwingUtil.setI18nTableHeaderRenderer(errorTable, I18n.n_((String)"validator.scope.header"), I18n.n_((String)"validator.scope.header.tip"), I18n.n_((String)"validator.field.header"), I18n.n_((String)"validator.field.header.tip"), I18n.n_((String)"validator.message.header"), I18n.n_((String)"validator.message.header.tip"));
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        SwingUtil.fixTableColumnWidth(errorTable, 0, 25);
    }

    public static SwingValidatorMessageListMouseListener registerErrorListMouseListener(JList list) {
        SwingValidatorMessageListMouseListener listener = SwingValidatorUtil.getErrorListMouseListener(list);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageListMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        list.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageTableMouseListener registerErrorTableMouseListener(JTable table) {
        SwingValidatorMessageTableMouseListener listener = SwingValidatorUtil.getErrorTableMouseListener(table);
        if (listener != null) {
            return listener;
        }
        listener = new SwingValidatorMessageTableMouseListener();
        if (log.isDebugEnabled()) {
            log.debug((Object)listener.toString());
        }
        table.addMouseListener(listener);
        return listener;
    }

    public static SwingValidatorMessageListMouseListener getErrorListMouseListener(JList list) {
        if (list != null) {
            for (MouseListener listener : list.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageListMouseListener)listener;
            }
        }
        return null;
    }

    public static SwingValidatorMessageTableMouseListener getErrorTableMouseListener(JTable table) {
        if (table != null) {
            for (MouseListener listener : table.getMouseListeners()) {
                if (!(listener instanceof SwingValidatorMessageTableMouseListener)) continue;
                return (SwingValidatorMessageTableMouseListener)listener;
            }
        }
        return null;
    }

    public static String getMessage(SwingValidatorMessage model) {
        String text = model.getMessage();
        if (model.getField() != null) {
            text = model.getField().getI18nError(text);
        }
        return text;
    }

    public static String getFieldName(SwingValidatorMessage model, String value) {
        String text = null;
        JComponent editor = model.getEditor();
        if (editor != null) {
            text = (String)editor.getClientProperty("validatorLabel");
        }
        if (text == null) {
            text = value;
        }
        return text;
    }

    public static ImageIcon getIcon(BeanValidatorScope scope) {
        ImageIcon icon = null;
        switch (scope) {
            case ERROR: {
                icon = SwingValidatorUtil.getErrorIcon();
                break;
            }
            case WARNING: {
                icon = SwingValidatorUtil.getWarningIcon();
                break;
            }
            case INFO: {
                icon = SwingValidatorUtil.getInfoIcon();
            }
        }
        return icon;
    }

    static {
        log = LogFactory.getLog(SwingValidatorUtil.class);
    }
}

