/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.beanutils.Converter;
import org.nuiton.util.ConverterUtil;

public class ClassCellEditor
implements TableCellEditor {
    protected TableCellEditor delegate;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String valStr = (value + "").trim();
        if (valStr.equals("null")) {
            valStr = "";
        } else if (valStr.startsWith("class ")) {
            valStr = valStr.substring(6);
        }
        Component comp = this.getDelegate().getTableCellEditorComponent(table, valStr, isSelected, row, column);
        return comp;
    }

    @Override
    public Object getCellEditorValue() {
        Class<?> o;
        Class<?> clazz = o = !this.hasDelegate() ? null : this.delegate.getCellEditorValue();
        if (o == null) {
            return null;
        }
        Converter converter = ConverterUtil.getConverter(Class.class);
        try {
            if (converter != null) {
                return converter.convert(Class.class, (Object)o);
            }
            o = Class.forName(o + "");
        }
        catch (Exception e) {
            o = null;
        }
        return o;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !this.hasDelegate() || this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.hasDelegate() && this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return !this.hasDelegate() || this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.hasDelegate()) {
            this.delegate.cancelCellEditing();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.addCellEditorListener(l);
        }
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (this.hasDelegate()) {
            this.delegate.removeCellEditorListener(l);
        }
    }

    protected TableCellEditor getDelegate() {
        if (this.delegate == null) {
            this.delegate = new DefaultCellEditor(new JTextField());
        }
        return this.delegate;
    }

    protected boolean hasDelegate() {
        return this.delegate != null;
    }
}

