/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDataSourceFactory
implements ObjectFactory {
    private static TraceSystem cachedTraceSystem;
    private Trace trace = this.getTraceSystem().getTrace("JDBCX");

    @Override
    public synchronized Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) {
        Reference reference;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("getObjectInstance obj=" + object + " name=" + name + " nameCtx=" + context + " environment=" + hashtable);
        }
        if ((reference = (Reference)object).getClassName().equals(JdbcDataSource.class.getName())) {
            JdbcDataSource jdbcDataSource = new JdbcDataSource();
            jdbcDataSource.setURL((String)reference.get("url").getContent());
            jdbcDataSource.setUser((String)reference.get("user").getContent());
            jdbcDataSource.setPassword((String)reference.get("password").getContent());
            String string = (String)reference.get("loginTimeout").getContent();
            jdbcDataSource.setLoginTimeout(Integer.parseInt(string));
            return jdbcDataSource;
        }
        return null;
    }

    private TraceSystem getTraceSystem() {
        if (cachedTraceSystem == null) {
            cachedTraceSystem = new TraceSystem(SysProperties.CLIENT_TRACE_DIRECTORY + "h2datasource" + ".trace.db", false);
            cachedTraceSystem.setLevelFile(SysProperties.DATASOURCE_TRACE_LEVEL);
        }
        return cachedTraceSystem;
    }

    Trace getTrace() {
        return this.trace;
    }

    static {
        Driver.load();
    }
}

