/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.RestrictionHelper;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.Like;
import org.nuiton.wikitty.search.operators.Restriction;
import org.nuiton.wikitty.search.operators.SubSearch;

public class Search {
    protected KIND kind = KIND.AND;
    protected List<Restriction> restrictions = new ArrayList<Restriction>();
    protected List<Search> subSearchs = new ArrayList<Search>();

    public static Search query(Wikitty wikitty) {
        Search result = Search.query();
        result.kind = KIND.AND;
        for (String extName : wikitty.getExtensionNames()) {
            result.eq(Element.ELT_EXTENSION, extName);
        }
        for (String fqfieldName : wikitty.fieldNames()) {
            Object value = wikitty.getFqField(fqfieldName);
            if (value == null) continue;
            FieldType type = wikitty.getFieldType(fqfieldName);
            if (type.isCollection()) {
                Collection collection = (Collection)value;
                for (Object o : collection) {
                    String strValue = WikittyUtil.toStringForSearchEngine(type, o);
                    result.eq(fqfieldName, strValue);
                }
                continue;
            }
            String strValue = WikittyUtil.toStringForSearchEngine(type, value);
            result.eq(fqfieldName, strValue);
        }
        return result;
    }

    public static Search query() {
        Search search = Search.query(KIND.AND);
        return search;
    }

    public static Search query(KIND kind) {
        Search search = new Search();
        search.kind = kind;
        return search;
    }

    public static Search query(Criteria criteria) {
        Search search = Search.query();
        if (criteria != null) {
            search.restrictions.add(criteria.getRestriction());
        }
        return search;
    }

    protected static Element elt(String element) {
        Element elm = new Element();
        elm.setName(element);
        return elm;
    }

    public Search contains(String element, Collection<String> values) {
        this.restrictions.add(RestrictionHelper.contains(Search.elt(element), new ArrayList<String>(values)));
        return this;
    }

    public Search contains(String element, String value) {
        this.restrictions.add(RestrictionHelper.contains(Search.elt(element), value, new String[0]));
        return this;
    }

    public Search eq(String element, String value) {
        this.restrictions.add(RestrictionHelper.eq(Search.elt(element), value));
        return this;
    }

    public Search eq(String element, Collection<String> values) {
        for (String value : values) {
            this.restrictions.add(RestrictionHelper.eq(Search.elt(element), value));
        }
        return this;
    }

    public Search like(String element, String value, Like.SearchAs searchAs) {
        this.restrictions.add(RestrictionHelper.like(Search.elt(element), value, searchAs));
        return this;
    }

    public Search like(String element, String value) {
        this.restrictions.add(RestrictionHelper.like(Search.elt(element), value, Like.SearchAs.AsText));
        return this;
    }

    public Search unlike(String element, String value, Like.SearchAs searchAs) {
        this.restrictions.add(RestrictionHelper.unlike(Search.elt(element), value, searchAs));
        return this;
    }

    public Search unlike(String element, String value) {
        this.restrictions.add(RestrictionHelper.unlike(Search.elt(element), value, Like.SearchAs.AsText));
        return this;
    }

    public Search neq(String element, String value) {
        this.restrictions.add(RestrictionHelper.neq(Search.elt(element), value));
        return this;
    }

    public Search gt(String element, String value) {
        this.restrictions.add(RestrictionHelper.great(Search.elt(element), value));
        return this;
    }

    public Search ge(String element, String value) {
        this.restrictions.add(RestrictionHelper.greatEq(Search.elt(element), value));
        return this;
    }

    public Search lt(String element, String value) {
        this.restrictions.add(RestrictionHelper.less(Search.elt(element), value));
        return this;
    }

    public Search le(String element, String value) {
        this.restrictions.add(RestrictionHelper.lessEq(Search.elt(element), value));
        return this;
    }

    public Search bw(String element, String lowerValue, String upperValue) {
        this.restrictions.add(RestrictionHelper.between(Search.elt(element), lowerValue, upperValue));
        return this;
    }

    public Search sw(String element, String value) {
        this.restrictions.add(RestrictionHelper.start(Search.elt(element), value));
        return this;
    }

    public Search nsw(String element, String value) {
        this.restrictions.add(RestrictionHelper.not(RestrictionHelper.start(Search.elt(element), value)));
        return this;
    }

    public Search ew(String element, String value) {
        this.restrictions.add(RestrictionHelper.end(Search.elt(element), value));
        return this;
    }

    public Search notew(String element, String value) {
        this.restrictions.add(RestrictionHelper.not(RestrictionHelper.end(Search.elt(element), value)));
        return this;
    }

    public Search keyword(String value) {
        this.restrictions.add(RestrictionHelper.keyword(value));
        return this;
    }

    public Search isNull(String fieldName) {
        this.restrictions.add(RestrictionHelper.isNull(fieldName));
        return this;
    }

    public Search isNotNull(String fieldName) {
        this.restrictions.add(RestrictionHelper.isNotNull(fieldName));
        return this;
    }

    public Search not() {
        Search not = Search.query(KIND.NOT);
        this.subSearchs.add(not);
        Search search = Search.query(this.kind);
        not.subSearchs.add(search);
        return search;
    }

    public Search or() {
        Search search = Search.query(KIND.OR);
        this.subSearchs.add(search);
        return search;
    }

    public Search and() {
        Search search = Search.query(KIND.AND);
        this.subSearchs.add(search);
        return search;
    }

    public Search associated(String foreignFieldName) {
        SubSearch search = new SubSearch(foreignFieldName, this);
        return search;
    }

    public Criteria criteria(String name) {
        Criteria criteria = new Criteria(name);
        Restriction result = this.getRestrictions();
        criteria.setRestriction(result);
        return criteria;
    }

    public Criteria criteria() {
        Criteria criteria = this.criteria(null);
        return criteria;
    }

    protected Restriction getRestrictions() throws UnsupportedOperationException {
        Restriction result;
        if (this.restrictions.isEmpty() && this.subSearchs.isEmpty()) {
            result = RestrictionHelper.rFalse();
        } else if (this.restrictions.size() == 1 && this.subSearchs.isEmpty()) {
            result = this.restrictions.remove(0);
        } else if (this.subSearchs.size() == 1 && this.restrictions.isEmpty()) {
            Search subSearch = this.subSearchs.get(0);
            result = subSearch.getRestrictions();
            if (this.kind == KIND.NOT) {
                result = RestrictionHelper.not(result);
            }
        } else {
            ArrayList<Restriction> allRestrictions = new ArrayList<Restriction>(this.restrictions);
            for (Search subSearch : this.subSearchs) {
                Restriction restriction = subSearch.getRestrictions();
                allRestrictions.add(restriction);
            }
            switch (this.kind) {
                case OR: {
                    result = RestrictionHelper.or(allRestrictions);
                    break;
                }
                case AND: {
                    result = RestrictionHelper.and(allRestrictions);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Can't handle restriction kind " + this.kind.name());
                }
            }
        }
        return result;
    }

    public static enum KIND {
        AND,
        OR,
        NOT;

    }
}

