/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.tests.perf.Configuration;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.Util;

public class JGroupsTransport
extends ReceiverAdapter
implements Transport {
    Properties config = null;
    Configuration cfg = null;
    JChannel channel = null;
    Thread t = null;
    String props = null;
    String group_name = "perf";
    Receiver receiver = null;
    boolean jmx = false;

    @Override
    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getAddress() : null;
    }

    @Override
    public String help() {
        return "[-props <props>]";
    }

    @Override
    public void create(Properties properties) throws Exception {
        this.config = properties;
        this.props = this.config.getProperty("props");
        this.jmx = Boolean.parseBoolean(this.config.getProperty("jmx"));
        this.channel = new JChannel(this.props);
        this.channel.setReceiver(this);
    }

    @Override
    public void create(Configuration config) throws Exception {
        this.cfg = config;
        String[] args = config.getTransportArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if (!tmp.equals("-props")) {
                    throw new IllegalArgumentException(tmp + " is not known (options: " + this.help() + ")");
                }
                this.props = args[++i];
            }
        }
        this.jmx = config.isJmx();
        this.channel = new JChannel(this.props);
        this.channel.setReceiver(this);
    }

    @Override
    public void start() throws Exception {
        this.channel.connect(this.group_name);
        if (this.jmx) {
            MBeanServer server = Util.getMBeanServer();
            if (server == null) {
                throw new Exception("No MBeanServers found;\nneeds to be run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel(this.channel, server, "jgroups.perf", this.channel.getClusterName(), true);
        }
    }

    @Override
    public void stop() {
        if (this.channel != null) {
            if (JGroupsTransport.isCoordinator(this.channel)) {
                for (int i = 0; i < 10; ++i) {
                    Util.sleep(300L);
                    if (this.channel.getView().size() == 1) break;
                }
            }
            this.channel.disconnect();
        }
        this.t = null;
    }

    @Override
    public void destroy() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    @Override
    public Map dumpStats() {
        return this.channel != null ? this.channel.dumpStats() : null;
    }

    @Override
    public void send(Object destination, byte[] payload, boolean oob) throws Exception {
        Message msg = new Message((Address)destination, null, payload);
        if (oob) {
            msg.setFlag((byte)1);
        }
        this.channel.send(msg);
    }

    @Override
    public void receive(Message msg) {
        Address sender = msg.getSrc();
        byte[] payload = msg.getBuffer();
        if (this.receiver != null) {
            try {
                this.receiver.receive(sender, payload);
            }
            catch (Throwable tt) {
                tt.printStackTrace();
            }
        }
    }

    private static boolean isCoordinator(Channel ch) {
        Vector<Address> members = ch.getView().getMembers();
        Address local_addr = ch.getAddress();
        return !members.isEmpty() && members.get(0).equals(local_addr);
    }
}

