/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import org.jgroups.blocks.MethodCall;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MethodCallTest {
    final TargetClass target = new TargetClass();

    public void testOld() {
        block2: {
            try {
                MethodCall mc = new MethodCall("foo", new Object[]{new Integer(22), "Bela"}, new Class[]{Integer.TYPE, String.class});
                Assert.assertEquals((Object)mc.invoke(this.target), (Object)Boolean.TRUE);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testOld2() {
        block2: {
            try {
                MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, "Bela"}, new Class[]{String[].class, String.class});
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testWithNull() {
        block2: {
            try {
                MethodCall mc = new MethodCall("foobar", null, (Class[])null);
                System.out.println("mc: " + mc);
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testOldWithNull() {
        block2: {
            try {
                MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, null}, new Class[]{String[].class, String.class});
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testOldWithNull2() {
        block2: {
            try {
                MethodCall mc = new MethodCall("bar", new Object[]{null, "Bela"}, new Class[]{String[].class, String.class});
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testOldWithNull3() {
        block2: {
            try {
                MethodCall mc = new MethodCall("foobar", null, (Class[])null);
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testOldWithNull4() {
        block2: {
            try {
                MethodCall mc = new MethodCall("foobar", new Object[0], (Class[])null);
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testMethod() {
        block2: {
            try {
                Method m = TargetClass.class.getMethod("foo", Integer.TYPE, String.class);
                MethodCall mc = new MethodCall(m, new Integer(22), "Bela");
                Assert.assertEquals((Object)mc.invoke(this.target), (Object)Boolean.TRUE);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypes() {
        block2: {
            MethodCall mc = new MethodCall("foo", new Object[]{new Integer(35), "Bela"}, new Class[]{Integer.TYPE, String.class});
            try {
                Assert.assertEquals((Object)mc.invoke(this.target), (Object)Boolean.TRUE);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypesWithArray() {
        block2: {
            MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, "Bela"}, new Class[]{String[].class, String.class});
            try {
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypesWithNullArgument() {
        block2: {
            MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, null}, new Class[]{String[].class, String.class});
            try {
                mc.invoke(this.target);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypesWithNullArgument2() throws Throwable {
        MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, new Object[0]}, new Class[]{String[].class, String.class});
        try {
            mc.invoke(this.target);
            assert (false) : "we should not get here as there should be an argument mismatch exception";
        }
        catch (IllegalArgumentException ex) {
            System.out.println("caught IllegalArgumentException - as expected");
        }
    }

    public void testTypesWithNullArgument3() {
        block3: {
            MethodCall mc = new MethodCall("foobar", new Object[0], new Class[0]);
            try {
                mc.invoke(this.target);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypesWithNullArgument4() {
        block3: {
            MethodCall mc = new MethodCall("foobar", null, (Class[])null);
            try {
                mc.invoke(this.target);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testTypesWithNullArgument5() {
        block3: {
            MethodCall mc = new MethodCall("foobar", new Object[0], new Class[0]);
            try {
                mc.invoke(this.target);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public void testSignature() {
        block2: {
            MethodCall mc = new MethodCall("foo", new Object[]{new Integer(35), "Bela"}, new String[]{Integer.TYPE.getName(), String.class.getName()});
            try {
                Assert.assertEquals((Object)mc.invoke(this.target), (Object)Boolean.TRUE);
            }
            catch (Throwable t) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)t.toString());
            }
        }
    }

    public static void testBufferSize() throws Exception {
        int a = 10;
        String b = "Bela";
        MethodCall m = new MethodCall("foo", new Object[]{new Integer(a), b}, new Class[]{Integer.TYPE, String.class});
        ByteArrayOutputStream msg_data = new ByteArrayOutputStream();
        ObjectOutputStream msg_out = new ObjectOutputStream(msg_data);
        m.writeExternal(msg_out);
        msg_out.flush();
        msg_out.close();
        byte[] data = msg_data.toByteArray();
        ByteArrayInputStream msg_in_data = new ByteArrayInputStream(data);
        ObjectInputStream msg_in = new ObjectInputStream(msg_in_data);
        MethodCall m2 = new MethodCall();
        m2.readExternal(msg_in);
        System.out.println(m2.getName());
        System.out.println(m2.getArgs().length);
    }

    public static void testOLD() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new Class[]{String.class});
        Target target = new Target();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testInheritanceOLD() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new Class[]{String.class});
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testMETHOD() throws Throwable {
        Method method = Target.class.getMethod("someMethod", String.class);
        MethodCall methodCall = new MethodCall(method, "abc");
        Target target = new Target();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testInheritanceMETHOD() throws Throwable {
        Method method = Target.class.getMethod("someMethod", String.class);
        MethodCall methodCall = new MethodCall(method, "abc");
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testTYPES() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new Class[]{String.class});
        Target target = new Target();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testInheritanceTYPES() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new Class[]{String.class});
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testOverriddenForTYPES() throws Throwable {
        MethodCall methodCall = new MethodCall("overriddenMethod", new Object[]{"abc"}, new Class[]{String.class});
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"TargetSubclassABC", (Object)result);
    }

    public static void testNoArgumentMethodForTYPES() throws Throwable {
        MethodCall methodCall = new MethodCall("noArgumentMethod", new Object[0], new Class[0]);
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"noArgumentMethodResult", (Object)result);
    }

    public static void testSIGNATURE() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new String[]{"java.lang.String"});
        Target target = new Target();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testInheritanceSIGNATURE() throws Throwable {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new String[]{"java.lang.String"});
        TargetSubclass target = new TargetSubclass();
        Object result = methodCall.invoke(target);
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    public static void testMarshalling() throws Exception {
        MethodCall methodCall = new MethodCall("someMethod", new Object[]{"abc"}, new String[]{"java.lang.String"});
        methodCall.put("name", "Bela");
        methodCall.put("id", new Integer(322649));
        System.out.println("methodCall: " + methodCall);
        MethodCall m = MethodCallTest.marshalAndUnmarshal(methodCall);
        System.out.println("m: " + m);
        Assert.assertEquals((Object)m.get("name"), (Object)"Bela");
        Assert.assertEquals((Object)m.get("id"), (Object)new Integer(322649));
    }

    private static MethodCall marshalAndUnmarshal(MethodCall m) throws Exception {
        byte[] buf = Util.objectToByteBuffer(m);
        return (MethodCall)Util.objectFromByteBuffer(buf);
    }

    public static class TargetSubclass
    extends Target {
        @Override
        public String overriddenMethod(String arg) {
            return "TargetSubclass" + arg.toUpperCase();
        }
    }

    public static class Target {
        public static String someMethod(String arg) {
            return arg.toUpperCase();
        }

        public String overriddenMethod(String arg) {
            return "Target" + arg.toUpperCase();
        }

        public static String noArgumentMethod() {
            return "noArgumentMethodResult";
        }
    }

    public static class TargetClass {
        public static boolean foo(int a, String b) {
            System.out.println("test(" + a + ", " + b + ')');
            return true;
        }

        public static void bar(String[] a, String b) {
            if (a != null) {
                for (int i = 0; i < a.length; ++i) {
                    String s = a[i];
                    System.out.print(s + ' ');
                }
            } else {
                System.out.println("a=null");
            }
            if (b != null) {
                System.out.println("b=" + b);
            } else {
                System.out.println("b=null");
            }
        }

        public static void foobar() {
            System.out.println("foobar()");
        }
    }
}

