/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.auth.AuthToken;
import org.jgroups.auth.X509Token;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AuthHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;

public class AUTH
extends Protocol {
    private AuthToken auth_plugin = null;
    private static final short gms_id = ClassConfigurator.getProtocolId(GMS.class);

    public AUTH() {
        this.name = "AUTH";
    }

    @Property(name="auth_class")
    public void setAuthClass(String class_name) throws Exception {
        Object obj = Class.forName(class_name).newInstance();
        this.auth_plugin = (AuthToken)obj;
        this.auth_plugin.setAuth(this);
    }

    public String getAuthClass() {
        return this.auth_plugin != null ? this.auth_plugin.getClass().getName() : null;
    }

    @Override
    protected List<Object> getConfigurableObjects() {
        LinkedList<Object> retval = new LinkedList<Object>();
        if (this.auth_plugin != null) {
            retval.add(this.auth_plugin);
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.auth_plugin instanceof X509Token) {
            X509Token tmp = (X509Token)this.auth_plugin;
            tmp.setCertificate();
        }
    }

    private Event createFailureEvent(Address joiner, String message) {
        Message msg = new Message(joiner, null, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating JoinRsp with failure message - " + message);
        }
        JoinRsp joinRes = new JoinRsp(message);
        GMS.GmsHeader gmsHeader = new GMS.GmsHeader(2, joinRes);
        msg.putHeader(gms_id, gmsHeader);
        if (this.log.isDebugEnabled()) {
            this.log.debug("GMSHeader created for failure JOIN_RSP");
        }
        return new Event(1, msg);
    }

    @Override
    public Object up(Event evt) {
        GMS.GmsHeader hdr = AUTH.isJoinMessage(evt);
        if (hdr != null && (hdr.getType() == 1 || hdr.getType() == 11)) {
            Message msg;
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH got up event");
            }
            if ((msg = (Message)evt.getArg()).getHeader(this.id) != null && msg.getHeader(this.id) instanceof AuthHeader) {
                AuthHeader authHeader = (AuthHeader)msg.getHeader(this.id);
                if (authHeader != null) {
                    if (this.auth_plugin.authenticate(authHeader.getToken(), msg)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("AUTH passing up event");
                        }
                        this.up_prot.up(evt);
                    } else {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("AUTH failed to validate AuthHeader token");
                        }
                        this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Authentication failed"));
                    }
                } else {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("AUTH failed to get valid AuthHeader from Message");
                    }
                    this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Failed to find valid AuthHeader in Message"));
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No AUTH Header Found");
                }
                this.sendRejectionMessage(msg.getSrc(), this.createFailureEvent(msg.getSrc(), "Failed to find an AuthHeader in Message"));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message not a JOIN_REQ - ignoring it");
            }
            return this.up_prot.up(evt);
        }
        return null;
    }

    private void sendRejectionMessage(Address dest, Event join_rsp) {
        if (dest == null) {
            this.log.error("destination is null, cannot send JOIN rejection message to null destination");
            return;
        }
        this.down_prot.down(join_rsp);
    }

    @Override
    public Object down(Event evt) {
        GMS.GmsHeader hdr = AUTH.isJoinMessage(evt);
        if (hdr != null && (hdr.getType() == 1 || hdr.getType() == 11)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH got down event");
            }
            Message msg = (Message)evt.getArg();
            AuthHeader authHeader = new AuthHeader();
            authHeader.setToken(this.auth_plugin);
            msg.putHeader(this.id, authHeader);
            if (this.log.isDebugEnabled()) {
                this.log.debug("AUTH passing down event");
            }
        }
        if (hdr != null && hdr.getType() == 2 && this.log.isDebugEnabled()) {
            this.log.debug(hdr.toString());
        }
        return this.down_prot.down(evt);
    }

    private static GMS.GmsHeader isJoinMessage(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(gms_id);
                if (obj == null || !(obj instanceof GMS.GmsHeader)) {
                    return null;
                }
                return (GMS.GmsHeader)obj;
            }
        }
        return null;
    }
}

