/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FacetTopic;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class ThesaurusManager {
    private static final Log log = LogFactory.getLog(ThesaurusManager.class);
    public static final String ROOT_THESAURUS_NAME = "Thesaurus";
    private final WikittyProxy proxy;

    public ThesaurusManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public ThesaurusManager() {
        this.proxy = ServiceHelper.getWikittyProxy();
    }

    public TreeNode getRootThesaurus() throws TechnicalException {
        Criteria criteria;
        TreeNode rootThesaurus;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRootThesaurus()");
        }
        if ((rootThesaurus = (TreeNode)this.proxy.findByCriteria(TreeNode.class, criteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", ROOT_THESAURUS_NAME).criteria())) == null) {
            log.warn((Object)"root thesaurus found, creating ...");
            rootThesaurus = new TreeNodeImpl();
            rootThesaurus.setName(ROOT_THESAURUS_NAME);
            rootThesaurus = (TreeNode)this.proxy.store((BusinessEntity)rootThesaurus);
        }
        log.info((Object)("root thesaurus: " + rootThesaurus));
        return rootThesaurus;
    }

    public List<TreeNode> getAllThesaurus() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllThesaurus()");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").criteria();
        List nodes = this.proxy.findAllByCriteria(TreeNode.class, criteria).getAll();
        log.info((Object)String.format("found %s thesaurus entries", nodes.size()));
        if (log.isDebugEnabled()) {
            for (TreeNode node : nodes) {
                log.debug((Object)String.format("thesaurus name:%s, children:%s", node.getName(), node.getChildren()));
            }
        }
        return nodes;
    }

    public TreeNode getThesaurus(String thesaurusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusId + ")"));
        }
        TreeNode node = (TreeNode)this.proxy.restore(TreeNode.class, thesaurusId);
        return node;
    }

    public List<TreeNode> getThesaurus(List<String> thesaurusIds) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getThesaurus(" + thesaurusIds + ")"));
        }
        List nodes = this.proxy.restore(TreeNode.class, thesaurusIds);
        return nodes;
    }

    public List<TreeNode> getChildrenThesaurus(String thesaurusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getChildrenThesaurus(" + thesaurusId + ")"));
        }
        Search query = Search.query();
        query.eq(Element.ELT_EXTENSION, "TreeNode");
        query.eq("TreeNode.parent", thesaurusId);
        Criteria criteria = query.criteria();
        PagedResult nodes = this.proxy.findAllByCriteria(TreeNode.class, criteria);
        List all = nodes.getAll();
        return all;
    }

    public Map<TreeNode, Integer> getNbFormsByThesaurus() throws TechnicalException {
        HashMap<TreeNode, Integer> result = new HashMap<TreeNode, Integer>();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNbFormsByThesaurus()");
        }
        List<TreeNode> allThesaurus = this.getAllThesaurus();
        for (TreeNode node : allThesaurus) {
            Map.Entry entry = this.proxy.restoreNode(TreeNode.class, node.getWikittyId());
            if (entry != null) {
                result.put(node, (Integer)entry.getValue());
                continue;
            }
            result.put(node, 0);
        }
        return result;
    }

    public int getNbFormsForThesaurus(String thesaurusId) throws TechnicalException {
        Map.Entry entry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNbFormsForThesaurus(" + thesaurusId + ")"));
        }
        if ((entry = this.proxy.restoreNode(TreeNode.class, thesaurusId)) == null) {
            return 0;
        }
        return (Integer)entry.getValue();
    }

    public List<TreeNode> proposeThesaurus(Form form, List<TreeNode> thesaurus) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"proposeThesaurus(form)");
        }
        if (form == null) {
            return null;
        }
        ArrayList<TreeNode> result = new ArrayList();
        Search search = Search.query();
        search.eq(Element.ELT_EXTENSION, "Form");
        search.eq("Infogene.id", form.getId());
        Criteria criteria = search.criteria();
        if (thesaurus == null) {
            thesaurus = this.getAllThesaurus();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)form.getThesaurus());
        }
        for (TreeNode treeNode : thesaurus) {
            if (form.getThesaurus() != null && form.getThesaurus().contains(treeNode.getWikittyId()) || !treeNode.getExtensionNames().contains(ROOT_THESAURUS_NAME)) continue;
            List tags = (List)treeNode.getField(ROOT_THESAURUS_NAME, "tags");
            Search tagSearch = Search.query((Search.KIND)Search.KIND.OR);
            tagSearch.keyword(treeNode.getName());
            if (tags == null) continue;
            for (String tag : tags) {
                tagSearch.keyword(tag);
            }
            Criteria facetCriteria = tagSearch.criteria(treeNode.getWikittyId());
            criteria.addFacetCriteria(facetCriteria);
        }
        PagedResult forms = this.proxy.findAllByCriteria(Form.class, criteria);
        Collection facets = forms.getFacetNames();
        ArrayList<String> thIds = new ArrayList<String>();
        block2: for (String facet : facets) {
            for (FacetTopic ft : forms.getTopic(facet)) {
                if (ft.getCount() <= 0) continue;
                thIds.add(ft.getTopicName());
                continue block2;
            }
        }
        result = this.getThesaurus(thIds);
        return result;
    }
}

