/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.services.ServiceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyUtil;

public class FormTypeManager {
    private static final Log log = LogFactory.getLog(FormTypeManager.class);
    private final WikittyProxy proxy;
    private Map<String, WikittyExtension> extensionCache = new HashMap<String, WikittyExtension>();

    public FormTypeManager(WikittyProxy proxy) {
        this.proxy = proxy;
    }

    public FormTypeManager() {
        this.proxy = ServiceHelper.getWikittyProxy();
    }

    private void fillExtensionCache() {
        if (this.extensionCache.isEmpty()) {
            WikittyService wikittyService = this.proxy.getWikittyService();
            List allExtensions = wikittyService.getAllExtensions(true);
            for (WikittyExtension extension : allExtensions) {
                if (!"Form".equals(extension.getRequires())) continue;
                this.extensionCache.put(extension.getName(), extension);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("FormType count : " + this.extensionCache.size()));
            }
        }
    }

    public List<WikittyExtension> getAllFormTypes() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllFormTypes()");
        }
        this.fillExtensionCache();
        ArrayList<WikittyExtension> list = new ArrayList<WikittyExtension>(this.extensionCache.values());
        return list;
    }

    public Map<String, WikittyExtension> getAllFormTypesMap() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllFormTypesMap()");
        }
        this.fillExtensionCache();
        HashMap<String, WikittyExtension> map = new HashMap<String, WikittyExtension>(this.extensionCache);
        return map;
    }

    public WikittyExtension getFormType(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormType(" + name + ")"));
        }
        Map<String, WikittyExtension> allFormTypes = this.getAllFormTypesMap();
        WikittyExtension wikittyExtension = allFormTypes.get(name);
        return wikittyExtension;
    }

    public Map<String, FieldType> getFormTypeFields(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFormTypeFields(" + name + ")"));
        }
        WikittyExtension extension = this.getFormType(name);
        HashMap<String, FieldType> fields = new HashMap<String, FieldType>();
        for (String fieldName : extension.getFieldNames()) {
            fields.put(fieldName, extension.getFieldType(fieldName));
        }
        return fields;
    }

    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires, Map<String, String> tagValues) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + name + ", fields, requires, tagValues)"));
        }
        if (name != null) {
            WikittyExtension lastVersion = this.getFormType(name);
            String newVersion = null;
            newVersion = lastVersion != null ? WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()) : "0.0";
            WikittyExtension extension = new WikittyExtension(name, newVersion, requires, new LinkedHashMap<String, FieldType>(fields));
            if (tagValues != null) {
                for (Map.Entry<String, String> entry : tagValues.entrySet()) {
                    extension.addTagValue(entry.getKey(), entry.getValue());
                }
            }
            List<WikittyExtension> extensions = Arrays.asList(extension);
            this.proxy.getWikittyService().storeExtension(extensions);
            log.info((Object)String.format("FormType named %s saved with id: %s and version: %s", name, extension.getId(), newVersion));
            this.extensionCache.put(name, extension);
            return extension;
        }
        return null;
    }

    public WikittyExtension updateFormType(WikittyExtension extension) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateFormType(" + extension.toDefinition() + ")"));
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (String fieldName : extension.getFieldNames()) {
            FieldType fieldType = extension.getFieldType(fieldName);
            fields.put(fieldName, fieldType);
        }
        return this.updateFormType(extension.getName(), fields, extension.getRequires(), extension.getTagValues());
    }
}

