/*
 * #%L
 * Vradi :: Services Web
 * 
 * $Id: WikittyServiceDelegator.java 1523 2010-09-28 16:41:41Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.2.0/vradi-services-web/src/main/java/com/jurismarches/vradi/services/WikittyServiceDelegator.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyTransaction;

/**
 * Wikitty proxy delegator.
 * 
 * This delegator exist only because we cannot put instance as hessian service.
 * 
 * This delegator just delegate everything to a static real wikitty service.
 * 
 * @author chatellier
 * @version $Revision: 1523 $
 * 
 * Last update : $Date: 2010-09-28 18:41:41 +0200 (mar., 28 sept. 2010) $
 * By : $Author: chatellier $
 */
public class WikittyServiceDelegator implements WikittyService {

    protected WikittyService delegate;

    public WikittyServiceDelegator() {
        delegate = ServiceFactory.getWikittyService();
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener,
            ServiceListenerType type) {
        delegate.addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener,
            ServiceListenerType type) {
        delegate.removeWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        return delegate.login(login, password);
    }

    @Override
    public void logout(String securityToken) {
        delegate.logout(securityToken);
    }

    @Override
    public void clear(String securityToken) {
        delegate.clear(securityToken);
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        return delegate.store(securityToken, wikitty);
    }

    @Override
    public UpdateResponse store(String securityToken,
            Collection<Wikitty> wikitties) {
        return delegate.store(securityToken, wikitties);
    }

    @Override
    public UpdateResponse store(String securityToken,
            Collection<Wikitty> wikitties, boolean force) {
        return delegate.store(securityToken, wikitties, force);
    }

    @Override
    public UpdateResponse store(String securityToken,
            WikittyTransaction transaction, Collection<Wikitty> wikitties,
            boolean force) {
        return delegate.store(securityToken, transaction, wikitties, force);
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return delegate.getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken,
            String extensionName) {
        return delegate.getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken,
            WikittyExtension ext) {
        return delegate.storeExtension(securityToken, ext);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken,
            Collection<WikittyExtension> exts) {
        return delegate.storeExtension(securityToken, exts);
    }

    @Override
    public UpdateResponse storeExtension(String securityToken,
            WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        return delegate.storeExtension(securityToken, transaction, exts);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        return delegate.restoreExtension(securityToken, id);
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken,
            WikittyTransaction transaction, String id) {
        return delegate.restoreExtension(securityToken, transaction, id);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken,
            String name) {
        return delegate.restoreExtensionLastVersion(securityToken, name);
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken,
            WikittyTransaction transaction, String name) {
        return delegate.restoreExtensionLastVersion(securityToken, transaction,
                name);
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        return delegate.restore(securityToken, id);
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> id) {
        return delegate.restore(securityToken, id);
    }
    
    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> id) {
        return delegate.restore(securityToken, transaction, id);
    }

    @Override
    public void delete(String securityToken, String id) {
        delegate.delete(securityToken, id);
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        delegate.delete(securityToken, ids);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken,
            Criteria criteria) {
        return delegate.findAllByCriteria(securityToken, criteria);
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken,
            WikittyTransaction transaction, Criteria criteria) {
        return delegate.findAllByCriteria(securityToken, transaction, criteria);
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        return delegate.findByCriteria(securityToken, criteria);
    }

    @Override
    public Wikitty findByCriteria(String s,
            WikittyTransaction wikittyTransaction, Criteria criteria) {
        return delegate.findByCriteria(s, wikittyTransaction, criteria);
    }

    @Override
    public void addLabel(String securityToken, String wikittyId, String label) {
        delegate.addLabel(securityToken, wikittyId, label);
    }

    @Override
    public PagedResult<String> findAllByLabel(String securityToken,
            String label, int firstIndex, int endIndex) {
        return delegate.findAllByLabel(securityToken, label, firstIndex,
                endIndex);
    }

    @Override
    public Wikitty findByLabel(String securityToken, String label) {
        return delegate.findByLabel(securityToken, label);
    }

    @Override
    public Set<String> findAllAppliedLabels(String securityToken,
            String wikittyId) {
        return delegate.findAllAppliedLabels(securityToken, wikittyId);
    }

    @Override
    public Tree restoreTree(String securityToken, String wikittyId) {
        return delegate.restoreTree(securityToken, wikittyId);
    }

    @Override
    public List<String> deleteTree(String securityToken, String wikittyId) {
        return delegate.deleteTree(securityToken, wikittyId);
    }

    @Override
    public Entry<TreeNode, Integer> restoreNode(String securityToken,
            String wikittyId, Criteria filter) {
        return delegate.restoreNode(securityToken, wikittyId, filter);
    }

    @Override
    public Map<TreeNode, Integer> restoreChildren(String securityToken,
            String wikittyId, Criteria filter) {
        return delegate.restoreChildren(securityToken, wikittyId, filter);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId,
            String version) {
        return delegate.restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public UpdateResponse syncEngin(String securityToken) {
        return delegate.syncEngin(securityToken);
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return delegate.canWrite(securityToken, wikitty);
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return delegate.canDelete(securityToken, wikittyId);
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return delegate.canRead(securityToken, wikittyId);
    }
}
