/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class InfogeneAbstract extends BusinessEntityImpl implements Infogene {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionInfogene;
    /**
     * getId :
     * @return String 
     */

    @Override
    public String getId() {
        String value = InfogeneHelper.getId(getWikitty());
        return value;
}

    /**
     * setId :
     * @param id 
     */

    @Override
    public void setId(String id) {
        String oldValue = getId();
        InfogeneHelper.setId(getWikitty(), id);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_ID, oldValue, getId());
}

    /**
     * getObjet :
     * @return String 
     */

    @Override
    public String getObjet() {
        String value = InfogeneHelper.getObjet(getWikitty());
        return value;
}

    /**
     * setObjet :
     * @param objet 
     */

    @Override
    public void setObjet(String objet) {
        String oldValue = getObjet();
        InfogeneHelper.setObjet(getWikitty(), objet);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_OBJET, oldValue, getObjet());
}

    /**
     * getCreationDate :
     * @return Date 
     */

    @Override
    public Date getCreationDate() {
        Date value = InfogeneHelper.getCreationDate(getWikitty());
        return value;
}

    /**
     * setCreationDate :
     * @param creationDate 
     */

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = getCreationDate();
        InfogeneHelper.setCreationDate(getWikitty(), creationDate);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_CREATIONDATE, oldValue, getCreationDate());
}

    /**
     * getSourceURL :
     * @return String 
     */

    @Override
    public String getSourceURL() {
        String value = InfogeneHelper.getSourceURL(getWikitty());
        return value;
}

    /**
     * setSourceURL :
     * @param sourceURL 
     */

    @Override
    public void setSourceURL(String sourceURL) {
        String oldValue = getSourceURL();
        InfogeneHelper.setSourceURL(getWikitty(), sourceURL);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_SOURCEURL, oldValue, getSourceURL());
}

    /**
     * getSourceText :
     * @return String 
     */

    @Override
    public String getSourceText() {
        String value = InfogeneHelper.getSourceText(getWikitty());
        return value;
}

    /**
     * setSourceText :
     * @param sourceText 
     */

    @Override
    public void setSourceText(String sourceText) {
        String oldValue = getSourceText();
        InfogeneHelper.setSourceText(getWikitty(), sourceText);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_SOURCETEXT, oldValue, getSourceText());
}

    /**
     * getEntity :
     * @return String 
     */

    @Override
    public String getEntity() {
        String value = InfogeneHelper.getEntity(getWikitty());
        return value;
}

    /**
     * setEntity :
     * @param entity 
     */

    @Override
    public void setEntity(String entity) {
        String oldValue = getEntity();
        InfogeneHelper.setEntity(getWikitty(), entity);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_ENTITY, oldValue, getEntity());
}

    /**
     * getCountry :
     * @return String 
     */

    @Override
    public String getCountry() {
        String value = InfogeneHelper.getCountry(getWikitty());
        return value;
}

    /**
     * setCountry :
     * @param country 
     */

    @Override
    public void setCountry(String country) {
        String oldValue = getCountry();
        InfogeneHelper.setCountry(getWikitty(), country);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_COUNTRY, oldValue, getCountry());
}

    /**
     * getDepartment :
     * @return String 
     */

    @Override
    public String getDepartment() {
        String value = InfogeneHelper.getDepartment(getWikitty());
        return value;
}

    /**
     * setDepartment :
     * @param department 
     */

    @Override
    public void setDepartment(String department) {
        String oldValue = getDepartment();
        InfogeneHelper.setDepartment(getWikitty(), department);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_DEPARTMENT, oldValue, getDepartment());
}

    /**
     * getDescription :
     * @return String 
     */

    @Override
    public String getDescription() {
        String value = InfogeneHelper.getDescription(getWikitty());
        return value;
}

    /**
     * setDescription :
     * @param description 
     */

    @Override
    public void setDescription(String description) {
        String oldValue = getDescription();
        InfogeneHelper.setDescription(getWikitty(), description);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_DESCRIPTION, oldValue, getDescription());
}

    /**
     * getTag :
     * @return Set<String> 
     */

    @Override
    public Set<String> getTag() {
        Set<String> result = InfogeneHelper.getTag(getWikitty());
        return result;
}

    /**
     * setTag :
     * @param tag 
     */

    @Override
    public void setTag(Set<String> tag) {
        Set<String> oldValue = getTag();
        InfogeneHelper.setTag(getWikitty(), tag);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, oldValue, getTag());
}

    /**
     * addAllTag :
     * @param tag 
     */

    @Override
    public void addAllTag(Set<String> tag) {
        Set<String> oldValue = getTag();
        InfogeneHelper.addAllTag(getWikitty(), tag);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, oldValue, getTag());
}

    /**
     * addTag :
     * @param element 
     */

    @Override
    public void addTag(String element) {
        InfogeneHelper.addTag(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * removeTag :
     * @param element 
     */

    @Override
    public void removeTag(String element) {
        InfogeneHelper.removeTag(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * clearTag :
     */

    @Override
    public void clearTag() {
        InfogeneHelper.clearTag(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_TAG, null, getTag());
}

    /**
     * getStatus :
     * @return String 
     */

    @Override
    public String getStatus() {
        String value = InfogeneHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    @Override
    public void setStatus(String status) {
        String oldValue = getStatus();
        InfogeneHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Infogene.FIELD_INFOGENE_STATUS, oldValue, getStatus());
}

    /**
     * InfogeneAbstract :
     */

    public InfogeneAbstract() {
        super();
}

    /**
     * InfogeneAbstract :
     * @param wikitty 
     */

    public InfogeneAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * InfogeneAbstract :
     * @param businessEntityImpl 
     */

    public InfogeneAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionInfogene =
                new WikittyExtension(EXT_INFOGENE,
                                     "2.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String id unique=\"true\"", 
                                             "String objet unique=\"true\"", 
                                             "Date creationDate unique=\"true\"", 
                                             "String sourceURL unique=\"true\"", 
                                             "String sourceText unique=\"true\"", 
                                             "String entity unique=\"true\"", 
                                             "String country unique=\"true\"", 
                                             "String department unique=\"true\"", 
                                             "String description unique=\"true\"", 
                                             "String tag[0-*] unique=\"true\"", 
                                             "Wikitty status unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionInfogene);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //InfogeneAbstract
