/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  class UserHelper {

    /**
     * UserHelper :
     * utility class all provided methods are accessible the static way
     */

    private UserHelper() {// empty
}

    /**
     * getName :
     * @param wikitty 
     * @return String 
     */

    public static String getName(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_NAME);
        return value;
}

    /**
     * setName :
     * @param wikitty 
     * @param name 
     * @return String 
     */

    public static String setName(Wikitty wikitty, String name) {
        String oldValue = getName(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_NAME, name);
        return oldValue;
}

    /**
     * getService :
     * @param wikitty 
     * @return String 
     */

    public static String getService(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_SERVICE);
        return value;
}

    /**
     * setService :
     * @param wikitty 
     * @param service 
     * @return String 
     */

    public static String setService(Wikitty wikitty, String service) {
        String oldValue = getService(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_SERVICE, service);
        return oldValue;
}

    /**
     * getEmail :
     * @param wikitty 
     * @return String 
     */

    public static String getEmail(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_EMAIL);
        return value;
}

    /**
     * setEmail :
     * @param wikitty 
     * @param email 
     * @return String 
     */

    public static String setEmail(Wikitty wikitty, String email) {
        String oldValue = getEmail(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_EMAIL, email);
        return oldValue;
}

    /**
     * getCreationDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getCreationDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(User.EXT_USER, User.FIELD_USER_CREATIONDATE);
        return value;
}

    /**
     * setCreationDate :
     * @param wikitty 
     * @param creationDate 
     * @return Date 
     */

    public static Date setCreationDate(Wikitty wikitty, Date creationDate) {
        Date oldValue = getCreationDate(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_CREATIONDATE, creationDate);
        return oldValue;
}

    /**
     * getValidEmail :
     * @param wikitty 
     * @return boolean 
     */

    public static boolean getValidEmail(Wikitty wikitty) {
        boolean value = wikitty.getFieldAsBoolean(User.EXT_USER, User.FIELD_USER_VALIDEMAIL);
        return value;
}

    /**
     * setValidEmail :
     * @param wikitty 
     * @param validEmail 
     * @return boolean 
     */

    public static boolean setValidEmail(Wikitty wikitty, boolean validEmail) {
        boolean oldValue = getValidEmail(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_VALIDEMAIL, validEmail);
        return oldValue;
}

    /**
     * getAddress :
     * @param wikitty 
     * @return String 
     */

    public static String getAddress(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_ADDRESS);
        return value;
}

    /**
     * setAddress :
     * @param wikitty 
     * @param address 
     * @return String 
     */

    public static String setAddress(Wikitty wikitty, String address) {
        String oldValue = getAddress(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_ADDRESS, address);
        return oldValue;
}

    /**
     * getPhone :
     * @param wikitty 
     * @return String 
     */

    public static String getPhone(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(User.EXT_USER, User.FIELD_USER_PHONE);
        return value;
}

    /**
     * setPhone :
     * @param wikitty 
     * @param phone 
     * @return String 
     */

    public static String setPhone(Wikitty wikitty, String phone) {
        String oldValue = getPhone(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_PHONE, phone);
        return oldValue;
}

    /**
     * getBeginSearchDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getBeginSearchDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(User.EXT_USER, User.FIELD_USER_BEGINSEARCHDATE);
        return value;
}

    /**
     * setBeginSearchDate :
     * @param wikitty 
     * @param beginSearchDate 
     * @return Date 
     */

    public static Date setBeginSearchDate(Wikitty wikitty, Date beginSearchDate) {
        Date oldValue = getBeginSearchDate(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_BEGINSEARCHDATE, beginSearchDate);
        return oldValue;
}

    /**
     * getEnable :
     * @param wikitty 
     * @return boolean 
     */

    public static boolean getEnable(Wikitty wikitty) {
        boolean value = wikitty.getFieldAsBoolean(User.EXT_USER, User.FIELD_USER_ENABLE);
        return value;
}

    /**
     * setEnable :
     * @param wikitty 
     * @param enable 
     * @return boolean 
     */

    public static boolean setEnable(Wikitty wikitty, boolean enable) {
        boolean oldValue = getEnable(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_ENABLE, enable);
        return oldValue;
}

    /**
     * getClient :
     * @param wikitty 
     * @return String 
     */

    public static String getClient(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(User.EXT_USER, User.FIELD_USER_CLIENT);
        return value;
}

    /**
     * setClient :
     * @param wikitty 
     * @param client 
     * @return String 
     */

    public static String setClient(Wikitty wikitty, String client) {
        String oldValue = getClient(wikitty);
        wikitty.setField(User.EXT_USER, User.FIELD_USER_CLIENT, client);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_NAME);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_NAME);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_SERVICE);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_SERVICE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_EMAIL);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_CREATIONDATE);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_CREATIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_VALIDEMAIL);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_VALIDEMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_ADDRESS);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_ADDRESS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_PHONE);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_PHONE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_BEGINSEARCHDATE);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_BEGINSEARCHDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_ENABLE);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_ENABLE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(User.EXT_USER, User.FIELD_USER_CLIENT);
            Object f2 = w2.getFieldAsObject(User.EXT_USER, User.FIELD_USER_CLIENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(User.EXT_USER);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : UserAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //UserHelper
