/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  class SessionHelper {

    /**
     * SessionHelper :
     * utility class all provided methods are accessible the static way
     */

    private SessionHelper() {// empty
}

    /**
     * getSessionDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getSessionDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
        return value;
}

    /**
     * setSessionDate :
     * @param wikitty 
     * @param sessionDate 
     * @return Date 
     */

    public static Date setSessionDate(Wikitty wikitty, Date sessionDate) {
        Date oldValue = getSessionDate(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE, sessionDate);
        return oldValue;
}

    /**
     * getNum :
     * @param wikitty 
     * @return int 
     */

    public static int getNum(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
        return value;
}

    /**
     * setNum :
     * @param wikitty 
     * @param num 
     * @return int 
     */

    public static int setNum(Wikitty wikitty, int num) {
        int oldValue = getNum(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_NUM, num);
        return oldValue;
}

    /**
     * getStatus :
     * @param wikitty 
     * @return int 
     */

    public static int getStatus(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
        return value;
}

    /**
     * setStatus :
     * @param wikitty 
     * @param status 
     * @return int 
     */

    public static int setStatus(Wikitty wikitty, int status) {
        int oldValue = getStatus(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS, status);
        return oldValue;
}

    /**
     * getParagraph :
     * @param wikitty 
     * @return String 
     */

    public static String getParagraph(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
        return value;
}

    /**
     * setParagraph :
     * @param wikitty 
     * @param paragraph 
     * @return String 
     */

    public static String setParagraph(Wikitty wikitty, String paragraph) {
        String oldValue = getParagraph(wikitty);
        wikitty.setField(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH, paragraph);
        return oldValue;
}

    /**
     * getSending :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getSending(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, String.class);
        return result;
}

    /**
     * addSending :
     * @param wikitty 
     * @param element 
     */

    public static void addSending(Wikitty wikitty, String element) {
        wikitty.addToField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
}

    /**
     * removeSending :
     * @param wikitty 
     * @param element 
     */

    public static void removeSending(Wikitty wikitty, String element) {
        wikitty.removeFromField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING, element);
}

    /**
     * clearSending :
     * @param wikitty 
     */

    public static void clearSending(Wikitty wikitty) {
        wikitty.clearField(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SESSIONDATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_NUM);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_STATUS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_PARAGRAPH);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
            Object f2 = w2.getFieldAsObject(Session.EXT_SESSION, Session.FIELD_SESSION_SENDING);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Session.EXT_SESSION);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : SessionAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //SessionHelper
