/*
 * #%L
 * Vradi :: Entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeAbstract;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUser;
import org.nuiton.wikitty.WikittyUserAbstract;
import org.nuiton.wikitty.WikittyUserImpl;
import org.nuiton.wikitty.WikittyUtil;


public  abstract class SessionAbstract extends BusinessEntityWikitty implements Session {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionSession;
    /**
     * getSessionDate :
     * @return Date 
     */

    @Override
    public Date getSessionDate() {
        Date value = SessionHelper.getSessionDate(getWikitty());
        return value;
}

    /**
     * setSessionDate :
     * @param sessionDate 
     */

    @Override
    public void setSessionDate(Date sessionDate) {
        Date oldValue = getSessionDate();
        SessionHelper.setSessionDate(getWikitty(), sessionDate);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SESSIONDATE, oldValue, getSessionDate());
}

    /**
     * getNum :
     * @return int 
     */

    @Override
    public int getNum() {
        int value = SessionHelper.getNum(getWikitty());
        return value;
}

    /**
     * setNum :
     * @param num 
     */

    @Override
    public void setNum(int num) {
        int oldValue = getNum();
        SessionHelper.setNum(getWikitty(), num);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_NUM, oldValue, getNum());
}

    /**
     * getStatus :
     * @return int 
     */

    @Override
    public int getStatus() {
        int value = SessionHelper.getStatus(getWikitty());
        return value;
}

    /**
     * setStatus :
     * @param status 
     */

    @Override
    public void setStatus(int status) {
        int oldValue = getStatus();
        SessionHelper.setStatus(getWikitty(), status);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_STATUS, oldValue, getStatus());
}

    /**
     * getParagraph :
     * @return String 
     */

    @Override
    public String getParagraph() {
        String value = SessionHelper.getParagraph(getWikitty());
        return value;
}

    /**
     * setParagraph :
     * @param paragraph 
     */

    @Override
    public void setParagraph(String paragraph) {
        String oldValue = getParagraph();
        SessionHelper.setParagraph(getWikitty(), paragraph);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_PARAGRAPH, oldValue, getParagraph());
}

    /**
     * getSending :
     * @return Set<String> 
     */

    @Override
    public Set<String> getSending() {
        Set<String> result = SessionHelper.getSending(getWikitty());
        return result;
}

    /**
     * addSending :
     * @param element 
     */

    @Override
    public void addSending(String element) {
        SessionHelper.addSending(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * removeSending :
     * @param element 
     */

    @Override
    public void removeSending(String element) {
        SessionHelper.removeSending(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * clearSending :
     */

    @Override
    public void clearSending() {
        SessionHelper.clearSending(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Session.FIELD_SESSION_SENDING, null, getSending());
}

    /**
     * SessionAbstract :
     */

    public SessionAbstract() {
        super();
}

    /**
     * SessionAbstract :
     * @param wikitty 
     */

    public SessionAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * SessionAbstract :
     * @param businessEntityWikitty 
     */

    public SessionAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionSession =
                new WikittyExtension(EXT_SESSION,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "Date sessionDate unique=true", 
                                             "Numeric num unique=true", 
                                             "Numeric status unique=true", 
                                             "String paragraph unique=true", 
                                             "Wikitty sending[0-*] unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionSession);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //SessionAbstract
