package com.jurismarches.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sharengo.wikitty.BusinessEntityWikitty;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyUtil;

public class ClientImpl extends com.jurismarches.vradi.entities.QueryMakerImpl implements Client, QueryMaker {

    private static final long serialVersionUID = 350009155L;


    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionClient =
        new WikittyExtension(EXT_CLIENT, "1", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"String email unique",
				"Date creationDate unique",
				"boolean validEmail unique",
				"String address unique",
				"String phone unique",
				"String contact unique",
				"Wikitty group[0-*] unique",
				"Wikitty user[0-*] unique",
				"Wikitty sending[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        exts.add(extensionClient);

        exts.addAll(QueryMakerImpl.extensions);
        extensions = Collections.unmodifiableList(exts);
    }
 
	public ClientImpl() {
		super();
	}

    public ClientImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ClientImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_CLIENT, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "name");
        return result;
    }


    public void setEmail(String email) {
        getWikitty().setField(EXT_CLIENT, "email", email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "email");
        return result;
    }


    public void setCreationDate(Date creationDate) {
        getWikitty().setField(EXT_CLIENT, "creationDate", creationDate);
    }

    public Date getCreationDate() {
        Date result = getWikitty().getFieldAsDate(EXT_CLIENT, "creationDate");
        return result;
    }


    public void setValidEmail(boolean validEmail) {
        getWikitty().setField(EXT_CLIENT, "validEmail", validEmail);
    }

    public boolean getValidEmail() {
        boolean result = getWikitty().getFieldAsBoolean(EXT_CLIENT, "validEmail");
        return result;
    }


    public void setAddress(String address) {
        getWikitty().setField(EXT_CLIENT, "address", address);
    }

    public String getAddress() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "address");
        return result;
    }


    public void setPhone(String phone) {
        getWikitty().setField(EXT_CLIENT, "phone", phone);
    }

    public String getPhone() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "phone");
        return result;
    }


    public void setContact(String contact) {
        getWikitty().setField(EXT_CLIENT, "contact", contact);
    }

    public String getContact() {
        String result = getWikitty().getFieldAsString(EXT_CLIENT, "contact");
        return result;
    }

    public Set<String> getGroup() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_CLIENT, "group", String.class);
        return result;
    }

    public void addGroup(String element) {
        getWikitty().addToField(EXT_CLIENT, "group", element);
    }
    
    public void removeGroup(String element) {
        getWikitty().removeFromField(EXT_CLIENT, "group", element);
    }
    
    public void clearGroup() {
        getWikitty().clearField(EXT_CLIENT, "group");
    }

    public Set<String> getUser() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_CLIENT, "user", String.class);
        return result;
    }

    public void addUser(String element) {
        getWikitty().addToField(EXT_CLIENT, "user", element);
    }
    
    public void removeUser(String element) {
        getWikitty().removeFromField(EXT_CLIENT, "user", element);
    }
    
    public void clearUser() {
        getWikitty().clearField(EXT_CLIENT, "user");
    }

    public Set<String> getSending() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_CLIENT, "sending", String.class);
        return result;
    }

    public void addSending(String element) {
        getWikitty().addToField(EXT_CLIENT, "sending", element);
    }
    
    public void removeSending(String element) {
        getWikitty().removeFromField(EXT_CLIENT, "sending", element);
    }
    
    public void clearSending() {
        getWikitty().clearField(EXT_CLIENT, "sending");
    }

    public Set<String> getQueries() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_QUERYMAKER, "queries", String.class);
        return result;
    }

    public void addQueries(String element) {
        getWikitty().addToField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void removeQueries(String element) {
        getWikitty().removeFromField(EXT_QUERYMAKER, "queries", element);
    }
    
    public void clearQueries() {
        getWikitty().clearField(EXT_QUERYMAKER, "queries");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //ClientImpl
