package com.cybelia.sandra.entities.trace;

import com.google.common.collect.Lists;
import java.util.List;

public class SuiviTourImpl extends SuiviTourAbstract {

    private static final long serialVersionUID = 1L;

    @Override
    public int getKmTotal() {
        return getKmArrivee() - getKmDepart();
    }

    @Override
    public CRTour getCRTour() {
        return super.getcRTour();
    }

    @Override
    public void setCRTour(CRTour crTour) {
        super.setcRTour(crTour);
    }

    @Override
    public List<SuiviEtape> getSuiviEtapes() {
        List<SuiviEtape> suiviEtapes = super.getSuiviEtapes();
        if (suiviEtapes == null) {
            return null;
        }
        List<SuiviEtape> actifSuiviEtape = Lists.newArrayList();
        for (SuiviEtape suiviEtape : suiviEtapes) {
            if (suiviEtape.isActif()) {
                actifSuiviEtape.add(suiviEtape);
            }
        }
        return actifSuiviEtape;
    }

    @Override
    public int sizeSuiviEtapes() {
        List<SuiviEtape> suiviEtapeList = getSuiviEtapes();
        if (suiviEtapeList == null) {
            return 0;
        }
        return suiviEtapeList.size();
    }

    @Override
    public boolean isActif() {
        List<SuiviEtape> etapes = getSuiviEtapes();
        boolean isActif = (etapes != null && !etapes.isEmpty());

        // keep it for futures requests
        super.setActif(isActif);

        return isActif;
    }
}
