package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class SuiviTourDAOAbstract<E extends SuiviTour> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SuiviTour.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.SuiviTour;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Tour> list = getContext()
                                                    .getDAO(Tour.class)
                                                    .findAllByProperties(Tour.PROPERTY_SUIVI_TOUR, entity);
                                            for (Tour item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSuiviTour())) {
                                                    item.setSuiviTour(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByStatus(int v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_STATUS, v);
        return result;
    }

    public List<E> findAllByStatus(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_STATUS, v);
        return result;
    }

    public E findByChauffeurNomPrenom(String v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_CHAUFFEUR_NOM_PRENOM, v);
        return result;
    }

    public List<E> findAllByChauffeurNomPrenom(String v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_CHAUFFEUR_NOM_PRENOM, v);
        return result;
    }

    public E findByDuree(Date v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_DUREE, v);
        return result;
    }

    public List<E> findAllByDuree(Date v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_DUREE, v);
        return result;
    }

    public E findByLitresGasoil(int v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_LITRES_GASOIL, v);
        return result;
    }

    public List<E> findAllByLitresGasoil(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_LITRES_GASOIL, v);
        return result;
    }

    public E findByKmDepart(int v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_KM_DEPART, v);
        return result;
    }

    public List<E> findAllByKmDepart(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_KM_DEPART, v);
        return result;
    }

    public E findByKmArrivee(int v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_KM_ARRIVEE, v);
        return result;
    }

    public List<E> findAllByKmArrivee(int v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_KM_ARRIVEE, v);
        return result;
    }

    public E findByActif(boolean v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_ACTIF, v);
        return result;
    }

    public List<E> findAllByActif(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_ACTIF, v);
        return result;
    }

    public E findContainsSuiviEtapes(SuiviEtape v) throws TopiaException {
        E result = findContains(SuiviTour.PROPERTY_SUIVI_ETAPES, v);
        return result;
    }

    public List<E> findAllContainsSuiviEtapes(SuiviEtape v) throws TopiaException {
        List<E> result = findAllContains(SuiviTour.PROPERTY_SUIVI_ETAPES, v);
        return result;
    }

    public E findByReel(Chauffeur v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_REEL, v);
        return result;
    }

    public List<E> findAllByReel(Chauffeur v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_REEL, v);
        return result;
    }

    public E findContainsSuiviUsines(SuiviUsine v) throws TopiaException {
        E result = findContains(SuiviTour.PROPERTY_SUIVI_USINES, v);
        return result;
    }

    public List<E> findAllContainsSuiviUsines(SuiviUsine v) throws TopiaException {
        List<E> result = findAllContains(SuiviTour.PROPERTY_SUIVI_USINES, v);
        return result;
    }

    public E findBycRTour(CRTour v) throws TopiaException {
        E result = findByProperty(SuiviTour.PROPERTY_C_RTOUR, v);
        return result;
    }

    public List<E> findAllBycRTour(CRTour v) throws TopiaException {
        List<E> result = findAllByProperty(SuiviTour.PROPERTY_C_RTOUR, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Tour.class) {
            TourDAO dao = (TourDAO)
                getContext().getDAO(Tour.class);
            tmp = dao.findAllBySuiviTour(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Tour.class, entity);
        if (!list.isEmpty()) {
            result.put(Tour.class, list);
        }

        return result;
    }

} //SuiviTourDAOAbstract<E extends SuiviTour>
