package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.entities.Chauffeur;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;

public interface SuiviTour extends TopiaEntity {

    String PROPERTY_STATUS = "status";

    String PROPERTY_CHAUFFEUR_NOM_PRENOM = "chauffeurNomPrenom";

    String PROPERTY_DUREE = "duree";

    String PROPERTY_LITRES_GASOIL = "litresGasoil";

    String PROPERTY_KM_DEPART = "kmDepart";

    String PROPERTY_KM_ARRIVEE = "kmArrivee";

    String PROPERTY_ACTIF = "actif";

    String PROPERTY_SUIVI_ETAPES = "suiviEtapes";

    String PROPERTY_REEL = "reel";

    String PROPERTY_SUIVI_USINES = "suiviUsines";

    String PROPERTY_C_RTOUR = "cRTour";

    void setStatus(int status);

    int getStatus();

    void setChauffeurNomPrenom(String chauffeurNomPrenom);

    String getChauffeurNomPrenom();

    void setDuree(Date duree);

    Date getDuree();

    void setLitresGasoil(int litresGasoil);

    int getLitresGasoil();

    void setKmDepart(int kmDepart);

    int getKmDepart();

    void setKmArrivee(int kmArrivee);

    int getKmArrivee();

    void setActif(boolean actif);

    boolean isActif();

    boolean getActif();

    void addSuiviEtapes(SuiviEtape suiviEtapes);

    void addAllSuiviEtapes(List<SuiviEtape> suiviEtapes);

    void setSuiviEtapes(List<SuiviEtape> suiviEtapes);

    void removeSuiviEtapes(SuiviEtape suiviEtapes);

    void clearSuiviEtapes();

    List<SuiviEtape> getSuiviEtapes();

    SuiviEtape getSuiviEtapesByTopiaId(String topiaId);

    int sizeSuiviEtapes();

    boolean isSuiviEtapesEmpty();

    void setReel(Chauffeur reel);

    Chauffeur getReel();

    void addSuiviUsines(SuiviUsine suiviUsines);

    void addAllSuiviUsines(List<SuiviUsine> suiviUsines);

    void setSuiviUsines(List<SuiviUsine> suiviUsines);

    void removeSuiviUsines(SuiviUsine suiviUsines);

    void clearSuiviUsines();

    List<SuiviUsine> getSuiviUsines();

    SuiviUsine getSuiviUsinesByTopiaId(String topiaId);

    int sizeSuiviUsines();

    boolean isSuiviUsinesEmpty();

    void setcRTour(CRTour cRTour);

    CRTour getcRTour();

    int getKmTotal();

    CRTour getCRTour();

    void setCRTour(CRTour crTour);

} //SuiviTour
