package com.cybelia.sandra.entities.synchro;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SynchroAbstract extends TopiaEntityAbstract implements Synchro {

    /**
     * Nom de l'attribut en BD : value
     */
    protected int value;

    private static final long serialVersionUID = 7147604263235433520L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_VALUE, int.class, value);
        visitor.end(this);
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.value;
        fireOnPreWrite(PROPERTY_VALUE, oldValue, value);
        this.value = value;
        fireOnPostWrite(PROPERTY_VALUE, oldValue, value);
    }

    @Override
    public int getValue() {
        fireOnPreRead(PROPERTY_VALUE, value);
        int result = this.value;
        fireOnPostRead(PROPERTY_VALUE, value);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_VALUE, this.value).
         toString();
        return result;
    }

} //SynchroAbstract
