package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class SecuriteGroupeAbstract extends TopiaEntityAbstract implements SecuriteGroupe {

    /**
     * Nom de l'attribut en BD : nom
     */
    protected String nom;

    private static final long serialVersionUID = 3919651433686183984L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NOM, String.class, nom);
        visitor.end(this);
    }

    @Override
    public void setNom(String nom) {
        String oldValue = this.nom;
        fireOnPreWrite(PROPERTY_NOM, oldValue, nom);
        this.nom = nom;
        fireOnPostWrite(PROPERTY_NOM, oldValue, nom);
    }

    @Override
    public String getNom() {
        fireOnPreRead(PROPERTY_NOM, nom);
        String result = this.nom;
        fireOnPostRead(PROPERTY_NOM, nom);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NOM, this.nom).
         toString();
        return result;
    }

} //SecuriteGroupeAbstract
